<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin_home extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
              if($this->session->userdata('id') != true){
            redirect('admin');
        }
        $this->load->model(['admin_about_model', 'master_model', 'MasterItem', 'MasterUnit', 'MasterUnitBin', 'MasterItemLog', 'TransaksiItem', 'Admin_user_model']);
    }

    public function pr_no_put($pr_no)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_slider_exist($pr_no);
        if ($cek != "") {

            $resp = [
                'message' => $cek,
                'result'  => $cek,
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
        }

        $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/slider/put/']);

        $response = $client->request('GET', $pr_no);

        $body = $response->getBody();
        echo $body;
    }

    //// api pick paint
    public function en_no_pick($en_no)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/pick/']);

        $response = $client->request('GET', $en_no);

        $body = $response->getBody();
        echo $body;
    }

    public function en_no_put($en_no)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_paint_exist($en_no);
        if ($cek != null) {
            $resp = [
                'message' => 'paint exist on ' . $cek->code,
                'result'  => $cek,
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
        }
        $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        $response = $client->request('GET', $en_no);

        $body = $response->getBody();
        echo $body;
    }
    
    //save pick paint
    public function insert_pick_paint()
    {
        $user_id      = $this->session->userdata('id');
        $pr_no        = $this->input->post('pr_no');
        $item_code    = $this->input->post('item_code');
        $exp_kg       = $this->input->post('exp_kg');
        $location     = $this->input->post('location');
        $avail_weight = $this->input->post('avail_weight');
        $out_weight   = $this->input->post('out_weight');
        $last_out_kg  = $this->input->post('last_out_kg');
        $last_out_qty  = $this->input->post('last_out_qty');
        $id_item      = $this->input->post('id_item');
        $id_ts_item      = $this->input->post('id_ts_item');
        $id_bin       = $this->input->post('id_bin');
        $in_code      = $this->input->post('in_code');
        // $en_code   = $this->input->post('en_code');
        $note   = $this->input->post('note');
        $submit = $this->input->post('submit');

        $data_ts_item = [
            'id_user'       => $user_id,
            'note'          => $note,
            'out_kg'        => $last_out_kg + $out_weight,
            'out_qty'        => $last_out_qty + 1,
            'is_active'     => 0,
            'last_activity' => date("Y/m/d"),
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            // 'in_code'       => $in_code,
            'out_code'    => $pr_no,
            'id_unit_bin' => $id_bin,
            'id_item'     => $id_item,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => 0,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => $exp_kg,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => 0,
            'status'      => 'PICK',
            'out_kg'      => $out_weight,
            'out_qty'     => 1,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'id_user'     => $user_id,
            'note'        => $note,
        ];

        echo "<pre>";
        print_r($data_ts_item);
        print_r($data_log);
        print_r($_POST);
        print_r($this->db->queries);
        //die;

        $this->db->trans_start();
        // update ts_item
        $this->TransaksiItem->where('id', $id_ts_item)->update($data_ts_item);

        //update ke ms_unit
        //$this->MasterUnit->where('id', $unit->id)->update($data_ms_unit);

        //update ke ms_unit_bin
        // if ($pcs == $avail_qty || $bin_empty == 'on') {
        $this->MasterUnitBin->where('id', $id_bin)->update([
            'id_current_item' => 0,
        ]);
        //}

        // insert log
        $this->MasterItemLog->insert($data_log);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "data gagal";
        }

        if ($submit == 'save') {
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
            // redirect
            redirect('admin_home/paint_pick_new');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }
    
    //save put paint
    public function insert_put_paint()
    {
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code     = $this->input->post('en_no');
        $item_code   = $this->input->post('item_color_code');
        $create_date = $this->input->post('item-date-create');
        $in_weight   = $this->input->post('kg');
        $submit      = $this->input->post('save_and_put');
        $unit        = $this->MasterUnit->where('id', 2)->get();

        // negecek item
        $item = $this->MasterItem
            ->where('code', $item_code)
            ->where('id_category', '2')
            ->get();
        
        if ($item == null) {
            $id_item = $this->MasterItem->getLastId();
        } else {
            $id_item = $item->id;
        }

        $data_item = [
            'id'          => $id_item,
            'id_category' => 2,
            'code'        => $item_code,
            'name'        => "",
            'unit_weight' => 0,
        ];
        

        //cari lokasi bin yg kosong
        $sql = "SELECT mib.* from ms_unit_bin as mib
                WHERE mib.id_current_item = 0
                and mib.id_unit =2 AND mib.capacity >=$in_weight
                order by mib.code ASC limit 1";

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            $this->session->set_flashdata('error-msg', 'No more space in unit');
            redirect('admin_home/paint_put_new');
            die;
        }

        $id_unit_Bin = $unitBin->id;

        // cek paint sudah pernah ada atau belum
        $sql = "SELECT * FROM ts_item WHERE is_active = 0 AND in_code = '".$in_code."'";
        $db_ts_item = $this->db->query($sql)->row();        
            
        if ($db_ts_item == null)
        {
            $exist_ts_item = 0;
            //blm ada
            $id_ts_item = $this->TransaksiItem->getLastId();
            $data_ts_item = [
            // 'id_category'   => 1,
            'id'          => $id_ts_item,
            'in_code'     => $in_code,
            'is_active'   => 1,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => 0,
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => $in_weight,
            'in_qty'      => 1,
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log   = [
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => 0,
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => $in_weight,
            'in_qty'      => 1,
            'id_user'     => $UserName,
            'status'      => 'PUT',
            'note'        => $note,
        ];

    } else {
        //sudah ada 
        $id_ts_item = $db_ts_item->id;
        $dif_kg = $db_ts_item->dif_kg;
        $dif_qty = $db_ts_item->dif_qty;

        $data_ts_item = [
            'in_code'     => $in_code,
            'is_active'   => 1,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_Bin,
            'dif_kg'        => $dif_kg + $in_weight,
            'dif_qty'        => $dif_qty + 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];
        $exist_ts_item = 1;

        $data_log   = [
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => 0,
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'dif_kg'       => $in_weight,
            'dif_qty'      => 1,
            'id_user'     => $UserName,
            'status'      => 'PUT',
            'note'        => $note,
        ];

    }

        
        
            $code_unit_Bin1 = $unitBin->code;
            $kata="Please store item on location " .$code_unit_Bin1;
            echo "<script>alert('".@$kata."');</script>";
        //dd($find_empty_paint_location);

        echo "<pre>";
        print_r($data_log);
        print_r($data_item);
        print_r($data_ts_item);
        print_r($_POST);
        die;

        $this->db->trans_start();
        if ($item == null) {
            // insert ke ts_item
            $this->MasterItem->insert($data_item);
        }
        
        if ($exist_ts_item == 0)
        {
            // insert ke ts_item
        $this->TransaksiItem->insert($data_ts_item);
         } else { //sudah ada update
         // update ts_item
            $this->TransaksiItem->where('id', $id_ts_item)->update($data_ts_item);
        }
        

        // insert ke ts_item_log
        $this->MasterItemLog->insert($data_log);

        $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
            'id_current_item' => $id_ts_item,
        ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }
        

        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

        $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        if ($submit == 'save') {
            // redirect
            //redirect('admin_home/index/8.php');
            echo "<script>alert('".@$kata."');window.location='index/8.php'</script>";
        }

        if ($submit == 'save_and_put') {
            // redirect
            //redirect('admin_home/paint_put_new');
            echo "<script>alert('".@$kata."');window.location='paint_put_new'</script>";
        }
        echo "successful";

    }

    public function find_pr_pik($pr_no)
    {
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_pr_out($pr_no, 'ts_item_log');
        if ($cek == true) {

            $resp = [
                'status' => 'not_found',
                'result' => [],
            ];

            echo json_encode($resp);
            return;
        }

        $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/slider/pick/']);

        $response = $client->request('GET', $pr_no);

        $body = $response->getBody();
        echo $body;
    }

    public function index()
    {
        // echo "string";
        // die();

        $UserID = $this->session->userdata('id');
        // print_r($UserID);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_home';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_home', $data);
    }

    ////////////////////////////////////////////////////////////////////////////
    public function put_new()
    {

        $UserID = $this->session->userdata('id');
        // print_r($UserID);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_put';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_put', $data);
    }

    //insert slider
    public function insert_put()
    {
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $create_date = $this->input->post('create_date');
        $submit      = $this->input->post('submit');
        $in_code     = $this->input->post('pr_no');
        $item_code   = $this->input->post('item_code');
        $item_name   = $this->input->post('item_name');
        $unit_weight = $this->input->post('unit_weight');
        $exp_qty     = $this->input->post('exp_qty');
        $exp_kg      = $this->input->post('exp_kg');
        $in_qty      = $this->input->post('pcs');
        $in_kg       = $this->input->post('kg');

        // $UserName    = '1';
        // $note        = "test";
        // $create_date = "2020-05-08";
        // $submit      = "save_and_put";
        // $in_code     = "PR02271710";
        // $item_code   = "1100750";
        // $item_name   = "05 CN DA8L ET PARTS";
        // $unit_weight = "0.005039";
        // $exp_qty     = "3832";
        // $exp_kg      = "19.309448";
        // $in_qty      = "3832";
        // $in_kg       = "19.309448";

        $category    = 1;
        $unit        = $this->MasterUnit->where('id', 1)->get();
        $balance_limit        =$unit->balance_limit;
        $tolerance        =$unit->tolerance;
        $shelf       = $unit->shelf;

        $last_position = $this->master_model->find_last_position();

        //echo $last_position;
        // die();
        $item = $this->MasterItem
            ->where('code', $item_code)
            ->where('name', $item_name)
            ->where('id_category', $category)
            ->get();

        if ($item == null) {
            $id_item = $this->MasterItem->getLastId();
        } else {
            $id_item = $item->id;
        }
        
        if ($last_position == 'kiri' && ($unit->balance_weight1  <= ($unit->balance_weight2 + $tolerance )) || ($last_position == 'kanan' && (($unit->balance_weight1 + $tolerance ) <= $unit->balance_weight2 )))  {

            $start = 1;
            $end   = $shelf / 2;
            // kiri
            $unitBin = $this->MasterUnitBin->where('id_unit', $unit->id)
                ->where('shelf >=', $start)
                ->where('shelf <=', $end)
                ->where('capacity >=', $in_kg)
                ->where('id_current_item', 0)
                ->get();
            $pos_bal = 1;
        } else {
            // kanan
            $start = ($shelf / 2) + 1;
            $end   = $shelf;

            $unitBin = $this->MasterUnitBin->where('id_unit', $unit->id)
                ->where('shelf >=', $start)
                ->where('shelf <=', $end)
                ->where('capacity >=', $in_kg)
                ->where('id_current_item', 0)
                ->get();
            $pos_bal = 2;
        }

        $data_item = [
            'id'          => $id_item,
            'id_category' => 1,
            'code'        => $item_code,
            'name'        => $item_name,
            'unit_weight' => $unit_weight,
        ];
        $id_ts_item = $this->TransaksiItem->getLastId();
        $data_log   = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $unitBin->id,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => $unit_weight,
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            'in_kg'       => $in_kg,
            'in_qty'      => $in_qty,
            'id_user'     => $UserName,
            'status'      => 'PUT',
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            // 'is_active' => $item_name,
            'note'        => $note,
        ];

        $data_ts_item = [
            // 'id_category'   => 1,
            'id'          => $id_ts_item,
            'in_code'     => $in_code,
            'is_active'   => 1,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $unitBin->id,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => $unit_weight,
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            'in_kg'       => $in_kg,
            'in_qty'      => $in_qty,
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        // echo "<pre>";
        // print_r($data_ts_item);
        // print_r($data_log);
        // print_r($data_item);
        // print_r($_POST);
        $id_unit_bin1 = $unitBin->code;
        $kata="Please store item on location " .$id_unit_bin1;
     //die;

        $this->db->trans_start();
        if ($item == null) {
            // insert ke ts_item
            $this->MasterItem->insert($data_item);
        }

        // insert ke ts_item
        $this->TransaksiItem->insert($data_ts_item);

        // insert ke ts_item_log
        $this->MasterItemLog->insert($data_log);

        if ($pos_bal == 1) {
            $this->MasterUnit->where('id', $unit->id)->update([
                'balance_weight1' => $unit->balance_weight1 + $in_kg,
            ]);
        } else {
            $this->MasterUnit->where('id', $unit->id)->update([
                'balance_weight2' => $unit->balance_weight2 + $in_kg,
            ]);
        }

        $this->MasterUnitBin->where('id', $unitBin->id)->update([
            'id_current_item' => $id_ts_item,
        ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code. '&desc3='. $in_kg .'';


        $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        //die;
        if ($submit == 'save') {
            // redirect
            //redirect('admin_home/index/8.php');
            echo "<script>alert('".@$kata."');window.location='index/8.php'</script>";
        }

        if ($submit == 'save_and_put') {
            // redirect
            //redirect('admin_home/put_new');
            echo "<script>alert('".@$kata."');window.location='put_new'</script>";
        }
        echo "successful";
    }

    public function check_en()
    {
        //header('Content-Type: application/json');
        $in_code = $this->input->post('in_code');
        $en_code = $this->input->post('en_code');
        if ($in_code == $en_code) {
            echo "Right";
        } else {
            echo "Code is different from " . $in_code;
        }

    }

    //////find paint

    public function find_paint()
    {
        header('Content-Type: application/json');
        $in_weight = $this->input->post('exp_kg');
        $code      = $this->input->post('item_code');
        $data_bin  = $this->db->query("SELECT mib.id as idb, mib.code,ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mib on mib.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item WHERE (ti.in_kg-ti.out_kg+ti.dif_kg)>='" . $in_weight . "' AND mi.code = '" . $code . "' AND ti.is_active = 1 AND mib.id_unit =2 ORDER BY ti.id ASC")->row();

        if ($data_bin == null) { //not found try to search next biggest available.
            $data_bin  = $this->db->query("SELECT mib.id as idb, mib.code,ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mib on mib.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item WHERE  mi.code = '" . $code . "' AND ti.is_active = 1 AND mib.id_unit =2 ORDER BY (ti.in_kg-ti.out_kg+ti.dif_kg) DESC")->row();
        }

        if ($data_bin == null) {
            $data['msg'] = "Item not found";
                echo json_encode([
                'content' => $this->load->view('admin/get_item_not_avail_html', $data, true),
            ]);
            return;
            die;
        }

        $data = [
            'tsItem' => $data_bin,
        ];
        echo json_encode([
            'msg'     => 'ok',
            'tsItem'  => $data_bin,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }

    ///buka mesin pick paint
    public function get_item_avail_open_paint()
    {
        header('Content-Type: application/json');

        $pr_open   = $this->input->post('pr_open');
        
        $category    = 1;

        $tsItem = $total = $this->db->query("
            SELECT
                    mu.static_depth, mi.code as code_item, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.id, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
            FROM
                ts_item
            INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
             LEFT join ms_unit as mu ON mu.id = mub.id_unit
             LEFT JOIN ms_item as mi ON mi.id = ts_item.id_item
            WHERE ts_item.is_active = 1 AND
                ts_item.in_code = '" . $pr_open . "'
                
            ")->row();
            $exp_kg = $tsItem->avail_kg;
            $item_code = $tsItem->code_item;
            $in_code = $tsItem->in_code;
            $ip = $tsItem->ip;
            $port = $tsItem->port;
            $unit_bin_shelf = $tsItem->shelf;
            $unit_bin_compartment = $tsItem->compartment;
            $static_depth         = $tsItem->static_depth;
            if ($static_depth == 0) {
                $unit_bin_depth       = $tsItem->depth;
            } else {
                $unit_bin_depth = $static_depth;
            }

        // data ketemu
        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';
        
         $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $tsItem,
        ];
        echo json_encode([
            'msg'     => (string) $resp->getBody(),
            'tsItem'  => $tsItem,
            // 'item'    => $item,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }


    ///buka mesin pick slider
    public function get_item_avail_open()
    {
        header('Content-Type: application/json');

        $pr_open   = $this->input->post('pr_open');
        
        $category    = 1;

        $tsItem = $total = $this->db->query("
            SELECT
                    mu.static_depth, mi.code as code_item, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.id, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
            FROM
                ts_item
            INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
             LEFT join ms_unit as mu ON mu.id = mub.id_unit
             LEFT JOIN ms_item as mi ON mi.id = ts_item.id_item
            WHERE ts_item.is_active = 1 AND
                ts_item.in_code = '" . $pr_open . "'
                
            ")->row();
        // print_r($tsItem);
        // die();
            $exp_kg = $tsItem->avail_kg;
            $item_code = $tsItem->code_item;
            $in_code = $tsItem->in_code;
            $ip = $tsItem->ip;
            $port = $tsItem->port;
            $unit_bin_shelf = $tsItem->shelf;
            $unit_bin_compartment = $tsItem->compartment;
            $static_depth         = $tsItem->static_depth;
            if ($static_depth == 0) {
                $unit_bin_depth       = $tsItem->depth;
            } else {
                $unit_bin_depth = $static_depth;
            }

        // data ketemu
        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';
        
         $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $tsItem,
        ];
        echo json_encode([
            'msg'     => (string) $resp->getBody(),
            'tsItem'  => $tsItem,
            // 'item'    => $item,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }

    //pick slider find
    public function get_item_avail()
    {
        header('Content-Type: application/json');

        $item_code   = $this->input->post('item_code');
        $exp_kg      = $this->input->post('exp_kg');

        // $item_name   = $this->input->post('item_name');
        // $unit_weight = $this->input->post('unit_weight');
        // $exp_qty     = $this->input->post('exp_qty');
        // $out_qty     = $this->input->post('pcs');
        // $out_kg      = $this->input->post('kg');

        // $item_code   = "3412860";    
        // $exp_kg      = "10";
        
        
        $category    = 1;

        $item = $this->MasterItem
            ->where('code', $item_code)
            // ->where('name', $item_name)
            ->where('id_category', $category)
            ->get();

        ///dapetin id item
        if ($item == null) {
            echo json_encode([
                'content' => 'Item not found',
            ]);
            //return;
            //die;
        }

        $id_item = $item->id;

        $unit      = $this->MasterUnit->where('id', 1)->get();
        
        //cari dulu di shelf yg sama barang 
        $last_shelf = $this->master_model->find_last_shelf(1);

        if ($last_shelf !=0) {
            $sql = "SELECT
                    mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
            FROM
                ts_item
            INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
             LEFT join ms_unit as mu ON mu.id = mub.id_unit
            WHERE ts_item.is_active = 1 AND
                ts_item.id_item = '" . $item->id . "' AND mub.id_unit = 1 AND
                mub.shelf =  '" . $last_shelf . "'  AND
                (in_kg-out_kg-dif_kg) >= '" . $exp_kg . "'
                ORDER BY  (in_kg-out_kg-dif_kg) ASC, ts_item.id ASC LIMIT 1";

            $tsItem = $total = $this->db->query($sql)->row();
        } else { //tdk ketemu di shelf yg sama
            $tsItem == null;
        }
        
        
        //cari posisi akhir dimana.. kiri atau kanan.
        $last_position = $this->master_model->find_last_position();
        $tolerance = $unit->tolerance;

        if ($tsItem == null && ($last_position == 'kiri' && (($unit->balance_weight1  + $tolerance)  >= $unit->balance_weight2) || ($last_position == 'kanan' && ($unit->balance_weight1 >= ($unit->balance_weight2 + $tolerance ) ))))  {

        // if ($unit->balance_weight1 >= $unit->balance_weight2) {
            //  'cari ke kiri yg lbh berat
            $start_shelf = 1;
            $end_shelf   = 29;
            $found_pos   = 1; // kiri
        } else {
            //  'cari ke kanan yg lbh berat
            $start_shelf = 30;
            $end_shelf   = 58;
            $found_pos   = 2; // kanan
        }

        $tsItem = $total = $this->db->query("
            SELECT
                    mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
            FROM
                ts_item
            INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
             LEFT join ms_unit as mu ON mu.id = mub.id_unit
            WHERE ts_item.is_active = 1 AND mub.id_unit = 1 AND
                ts_item.id_item = '" . $item->id . "' AND
                mub.shelf >= '" . $start_shelf . "' AND
                mub.shelf <=  '" . $end_shelf . "'  AND
                (in_kg-out_kg-dif_kg) >= '" . $exp_kg . "'
                ORDER BY  (in_kg-out_kg-dif_kg) ASC, ts_item.id ASC, mub.code ASC  LIMIT 1
            ")->row();

        if ($tsItem == null) { // not found move to other side
            // 'cari di balik ke-2
            if ($unit->balance_weight1 >= $unit->balance_weight2) {
                $start_shelf = 30;
                $end_shelf   = 58;
                $found_pos   = 2; //kanan
            } else {
                $start_shelf = 1;
                $end_shelf   = 29;
                $found_pos   = 1; // kiri
            }

            $tsItem = $total = $this->db->query("
                SELECT
                   mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, ts_item.in_code, mub.compartment, mub.depth, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
                FROM
                    ts_item
                INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
                LEFT join ms_unit as mu ON mu.id = mub.id_unit
                WHERE ts_item.is_active = 1 AND mub.id_unit = 1 AND
                    ts_item.id_item = '" . $item->id . "' AND
                    mub.shelf >= '" . $start_shelf . "' AND
                    mub.shelf <=  '" . $end_shelf . "'  AND
                    (in_kg-out_kg-dif_kg) >= '" . $exp_kg . "'
                    ORDER BY  (in_kg-out_kg-dif_kg) ASC, ts_item.id ASC, mub.code ASC  LIMIT 1
            ")->row();

            // if not found find the biggest stock available
            if ($tsItem == null) {
                $sql = "SELECT
                        mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
                FROM
                    ts_item
                INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
                 LEFT join ms_unit as mu ON mu.id = mub.id_unit
                WHERE ts_item.is_active = 1 AND
                    ts_item.id_item = '" . $item->id . "' AND mub.id_unit = 1 
                    ORDER BY  (in_kg-out_kg-dif_kg) DESC, ts_item.id DESC LIMIT 1";

                $tsItem = $total = $this->db->query($sql)->row();
            }
        }

        if ($tsItem != null) { // found 
            $in_code = $tsItem->in_code;
            $ip = $tsItem->ip;
            $port = $tsItem->port;
            $unit_bin_shelf = $tsItem->shelf;
            $static_depth = $tsItem->static_depth;
            $unit_bin_compartment = $tsItem->compartment;
            if ($static_depth == 0) {
                $unit_bin_depth       = $tsItem->depth;
            } else {
                $unit_bin_depth = $static_depth;
            }
        }
    
        

        if ($tsItem == null) {
            $data['msg'] = "Item not found";
                echo json_encode([
                //'content' => 'Item not found',
                'content' => $this->load->view('admin/get_item_not_avail_html', $data, true),
            ]);
            return;
            die;
        }

        // data ketemu
        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';

         $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $tsItem,
        ];
        echo json_encode([
            'msg'     => (string) $resp->getBody(),
            'tsItem'  => $tsItem,
            'item'    => $item,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }

    //insert pick slider
    public function insert_pick()
    {
        $submit         = $this->input->post('submit');
        $user_id        = $this->session->userdata('id');
        $note           = $this->input->post('note');
        $bin_empty      = $this->input->post('publish');
        $in_code        = $this->input->post('pr_no');
        $item_code      = $this->input->post('item_code');
        $item_name      = $this->input->post('item_name');
        $unit_weight    = $this->input->post('unit_weight');
        $exp_qty        = $this->input->post('exp_qty');
        $exp_kg         = $this->input->post('exp_kg');
        $avail_qty      = $this->input->post('avail_qty');
        $avail_kg       = $this->input->post('avail_kg');
        $pcs            = $this->input->post('pcs');
        $kg             = $this->input->post('kg');
        $id_item        = $this->input->post('item_id');
        $ms_unit_bin_id = $this->input->post('ms_unit_bin_id');
        $category       = 1;

        $unit    = $this->MasterUnit->where('id', 1)->get();
        $unitBin = $this->MasterUnitBin->where('id', $ms_unit_bin_id)->get();
        $tsItem  = $this->TransaksiItem->where('id', $unitBin->id_current_item)->get();
        $dif_qty = 0;
        $dif_kg  = 0;
        $out_kg  = $tsItem->out_kg + $kg;
        $out_qty = $tsItem->out_qty + $pcs;

        // maka habis
        if ($pcs == $avail_qty) {
            $data_ts_item = [
                'id_user'       => $user_id,
                'note'          => $note,
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'is_active'     => 0,
                'last_activity' => date("Y/m/d"),
            ];
        } else {
            $data_ts_item = [
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'is_active'     => 1,
                'last_activity' => date("Y/m/d"),
                'id_user'       => $user_id,
                'note'          => $note,
            ];
        }

        //' ambil semua
        if ($bin_empty == 'on') {
            $dif_qty = $tsItem->dif_qty + ($pcs - $avail_qty);
            $dif_kg  = $tsItem->dif_kg + ($kg - $avail_kg);

            $data_ts_item = [
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'dif_qty'       => $dif_qty,
                'dif_kg'        => $dif_kg,
                'is_active'     => 0,
                'last_activity' => date("Y/m/d"),
                'id_user'       => $user_id,
                'note'          => $note,
            ];
        }

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $tsItem->id,
            // 'in_code'       => $in_code,
            'out_code'    => $in_code,
            'id_unit_bin' => $ms_unit_bin_id,
            'id_item'     => $id_item,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $unit_weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            // 'in_kg'    => $in_kg,
            // 'in_qty'   => $in_qty,
            'status'      => 'PICK',
            'out_kg'      => $kg,
            'out_qty'     => $pcs,
            'dif_kg'      => $dif_kg,
            'dif_qty'     => $dif_qty,
            'id_user'     => $user_id,
            'note'        => $note,
        ];

        if ($unitBin->shelf <= ($unit->shelf / 2)) {
            //  'kiri
            $data_ms_unit = [
                'balance_weight1' => $unit->balance_weight1 - $kg,
            ];
        } else {
            //  'kanan
            $data_ms_unit = [
                'balance_weight2' => $unit->balance_weight2 - $kg,
            ];
        }

        // echo "<pre>";
        // print_r($_POST);
        // print_r($data_ts_item);
        // print_r($tsItem);
        // print_r($data_log);
        // print_r($this->db->queries);
        // die;

        $this->db->trans_start();
        // update ts_item
        $this->TransaksiItem->where('id', $tsItem->id)->update($data_ts_item);

        //update ke ms_unit
        $this->MasterUnit->where('id', $unit->id)->update($data_ms_unit);

        //update ke ms_unit_bin
        if ($pcs == $avail_qty || $bin_empty == 'on') {
            $this->MasterUnitBin->where('id', $ms_unit_bin_id)->update([
                'id_current_item' => 0,
            ]);
        }

        // insert log
        $this->MasterItemLog->insert($data_log);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "data gagal";
        }

        if ($submit == 'save') {
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
            // redirect
            redirect('admin_home/pick_new');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }

    
    ////////////////////////////////////////////////////////////////////////////

    public function pick_new()
    {
        $this->Admin_user_model->auth()->hasUpdate($menu_id = 5)->redirect('/admin_by_category/list');
        $UserID = $this->session->userdata('id');
        @$PR_ID = $this->uri->segment(3);
        if ($PR_ID != '') {
            $sql = "SELECT (ti.in_qty-ti.out_qty+ti.dif_qty) as exp_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as exp_kg, (ti.in_qty-ti.out_qty+ti.dif_qty) as avail_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  mub.code as codeb, mi.code, mi.name, mi.unit_weight FROM ts_item AS ti LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         LEFT join ms_item as mi ON mi.id = ti.id_item
         WHERE ti.in_code='" . $PR_ID . "' ";
            $qry               = $this->db->query($sql);
            $row               = $qry->result_array();
            $data['data_pick'] = $row;
        }
        $data['last_mt'] = $this->master_model->mst_last_np('ts_item_log','NP');

        // print_r($data['last_mt']);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_pick';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_pick', $data);
    }

    ////////////////////////////////////////////////////////////////////////////

    public function pick($id)
    {

        $UserID = $this->session->userdata('id');
        $sql    = "SELECT ti.*, mub.code as codeb, mi.code, mi.name FROM ts_item AS ti LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         LEFT join ms_item as mi ON mi.id = ti.id_item
         WHERE ti.in_code='" . $id . "' ";
        $qry               = $this->db->query($sql);
        $row               = $qry->result_array();
        $data['data_pick'] = $row;
        // echo "<pre>";
        // print_r($data['data_pick']);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_pick';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_pick_1', $data);
    }

    ////////////////////////////////////////////////////////////////////////////
    public function paint_put_new()
    {

        $UserID = $this->session->userdata('id');
        // print_r($UserID);
        // die();
        $data['active'] = 'admin_paints_put';       

        $this->load->view('admin/admin_paints_put', $data);
    }

    public function paint_pick_new()
    {

        $UserID = $this->session->userdata('id');
        @$PR_ID = $this->uri->segment(3);
        if ($PR_ID != '') {
         //    $sql = "SELECT (ti.in_qty-ti.out_qty+ti.dif_qty) as exp_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as exp_kg, mub.code as codeb, mi.code, mi.name FROM ts_item AS ti LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         // LEFT join ms_item as mi ON mi.id = ti.id_item
         // WHERE ti.in_code='" . $PR_ID . "' ";
            $sql = "SELECT (ti.in_qty-ti.out_qty+ti.dif_qty) as exp_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as exp_kg, (ti.in_qty-ti.out_qty+ti.dif_qty) as avail_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  mub.code as codeb, mi.code, mi.name, mi.unit_weight FROM ts_item AS ti LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         LEFT join ms_item as mi ON mi.id = ti.id_item
         WHERE ti.in_code='" . $PR_ID . "' ";
            $qry               = $this->db->query($sql);
            $row               = $qry->result_array();
            $data['data_pick'] = $row;
        }
        $data['last_mt'] = $this->master_model->mst_last_np('ts_item_log','NP');
        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_paints_pick';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_paints_pick', $data);
    }

    /////////////////////////////////////////////////////////////////////

    public function check_code_unit()
    {
        $code = $this->input->post('pr_no');
        // echo $code;
        // die();
        $cek = $this->master_model->cek_pr1($code, 'ts_item');

        if ($cek) {
            echo '0';
        } else {
            echo '1';
        }
    }

    public function check_code_unit_out()
    {
        $code = $this->input->post('pr_no');
        // echo $code;
        // die();
        $cek = $this->master_model->cek_pr_out($code, 'ts_item_log');

        if ($cek) {
            echo '0';
        } else {
            echo '1';
        }
    }

    ///////////////////////////////////////////////////////////////////////

    public function edit_process($MENU_ID, $AboutID)
    {

        $PublishFlg = 0;

        $CekImage = $this->admin_about_model->CekImage($AboutID);
        $Cek      = $CekImage[0]['Image'];

        if ($this->input->post('PublishFlg') == 'on') {
            $PublishFlg = 1;
        }

        if ($this->input->post('ImageType') != '') {
            if ($this->input->post('ImageType') == 'NoImage') {
                if ($Cek != "") {
                    unlink('./uploads/about/' . $Cek);
                }
                $ImageName = "";
            } else if ($this->input->post('ImageType') == 'UploadNew') {
                $ImageName = $AboutID . '.' . substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);

                if ($Cek != "") {
                    unlink('./uploads/about/' . $Cek);
                }
                $this->uploadImage($AboutID);
            } else if ($this->input->post('ImageType') == 'SelectList') {
                $ImageName = $this->input->post('ImageCurrent');
            }

            $data = array(
                'AboutName'   => $this->input->post('Name'),
                'E_AboutName' => $this->input->post('E_Name'),
                'ShortDesc'   => $this->input->post('ShortDesc'),
                'E_ShortDesc' => $this->input->post('E_ShortDesc'),
                'LongDesc'    => $this->input->post('LongDesc'),
                'E_LongDesc'  => $this->input->post('E_LongDesc'),
                'Image'       => $ImageName,
                'PublishFlg'  => $PublishFlg,
            );
        } else {
            $data = array(
                'AboutName'   => $this->input->post('Name'),
                'E_AboutName' => $this->input->post('E_Name'),
                'ShortDesc'   => $this->input->post('ShortDesc'),
                'E_ShortDesc' => $this->input->post('E_ShortDesc'),
                'LongDesc'    => $this->input->post('LongDesc'),
                'E_LongDesc'  => $this->input->post('E_LongDesc'),
                'PublishFlg'  => $PublishFlg,
            );
        }

        $this->db->where('AboutID', $AboutID);
        $this->db->update('about', $data);

        redirect('admin_about/index/' . $MENU_ID);

    }

    public function uploadImage($AboutID)
    {
        $config['file_name']     = $AboutID;
        $config['upload_path']   = './uploads/about';
        $config['allowed_types'] = 'gif|jpg|png';
        $config['max_size']      = '100';
        $config['max_width']     = '1024';
        $config['max_height']    = '768';

        $this->load->library('upload', $config);
        $this->upload->do_upload('ImageUpload');
    }
}
