<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin_home extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        if($this->session->userdata('id') != true){
            redirect('admin');
        }
        $this->load->model(['admin_about_model', 'master_model', 'MasterItem', 'MasterUnit', 'MasterUnitBin', 'MasterItemLog', 'TransaksiItem', 'Admin_user_model']);
    }

    function go_to_test_mode()
    {
        // echo "string";
        // die;
        $this->load->helper('cookie');
        $cookie = [
            'name'   => 'sopro_test_mode',
            'value'  => 'dbtest',
            'expire' => 3600 * 9,
        ];
        $this->input->set_cookie($cookie);
        //$this->session->set_flashdata('mdt','<div class="alert alert-danger">Mode Database Test <a href=https://erka.solusiprogram.net/sopro/admin/home/quit_test_mode class="btn btn-xs bg-blue pull-right">Quit Test</a> </div>');
        //redirect('http://demo.solusiprogram.net/cl/storage/admin_home/index/8.php');
        redirect('admin_home/index');
    }

    public function quit_test_mode()
    {
        if (isset($_COOKIE['sopro_test_mode'])) {
             $this->load->helper('cookie');
            delete_cookie('sopro_test_mode');
            redirect('admin_home/index');
            //redirect('http://demo.solusiprogram.net/cl/storage/admin_home/index/8.php');
        //     $data['info'] = $info; asd

        // $this->load->view('admin/monitoring', $data);
        }
    }

    public function pr_no_put($pr_no)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_slider_exist($pr_no);
        if ($cek != "") {

            $resp = [
                'message' => $cek,
                'result'  => $cek,
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
        }

        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/slider/put/']);

        // $response = $client->request('GET', $pr_no);

        // $body = $response->getBody();
        // echo $body;
                // $resp = [
                //         'ITEM_CODE'      => '1100750',
                //         'ITEM_NAME'      => '05 CN DA8L ET PARTS',
                //         'CREATE_DATE'    => "2020-05-08",
                //         'UNIT_WEIGHT'    => "0.005039",
                //         'EXP_WEIGHT_KG'  => "19.309",
                //         'EXP_QTY'        => "3832",
                //     ];
            $resp = [
                'ITEM_CODE'      => '1100750X',
                'ITEM_NAME'      => '05 CN DA8L ET PARTS RUBBER',
                'CREATE_DATE'    => "2020-05-08",
                'UNIT_WEIGHT'    => "0.001",
                'EXP_WEIGHT_KG'  => "1",
                'EXP_QTY'        => "1000",
            ];

            echo json_encode($resp);
            return;
    }

    //// api pick paint
    public function en_no_pick($en_no)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/pick/']);

        $response = $client->request('GET', $en_no);

        $body = $response->getBody();
        echo $body;
    }

    public function en_no_pick_new($en_no)
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_sparepart_exist($en_no);
        $id_item = $cek->id_item;
        $cek_code = $this->master_model->select_in('ms_item', 'code', "WHERE id=$id_item");
            $code_ms_item = $cek_code[0]->code;
        $id_msunib = $cek->id_bin_group;
         $cek1 = $this->master_model->cek_code_group3($id_msunib, $cek->id_unit);
         $id_crnt = $cek->id_current_item;
         if($id_crnt == '0'){
            $resp = [
                'message'  => 'paint exist on ' . $cek->code,
                'status'   => false,
            ];
             echo json_encode($resp);
            return;
         }
        if ($id_crnt != null) {
            $resp1 = [
                'message' => 'paint exist on ' . $cek->code,
                'result'  => $cek,
                'result1' => $cek->id_unit,
                'result2' => $cek->id_bin_group,
                'cek1'    => $cek1,
                'id_ts_item'   => $cek->id_current_item,
                'in_qty'       => $cek->in_qty,
                'code_ms_item' => $code_ms_item,
                'status'       => true,
            ];

            echo json_encode($resp1);
            return;
        }
        echo json_encode($en_no);
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }



    public function en_no_put($en_no)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_paint_exist($en_no);
        if ($cek != null) {
            $resp = [
                'message' => 'paint exist on ' . $cek->code,
                'result'  => $cek,
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
        }
        $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        $response = $client->request('GET', $en_no);

        $body = $response->getBody();
        echo $body;
    }
    
    //save pick paint
    public function insert_pick_paint()
    {
        date_default_timezone_set('Asia/Jakarta');
        $date_now = date('Y-m-d h:i:s');           
        $user_id      = $this->session->userdata('id');
        $pr_no        = strtoupper(trim($this->input->post('pr_no')));
        $item_code    = strtoupper(trim($this->input->post('item_code')));
        $exp_kg       = $this->input->post('exp_kg');
        $location     = $this->input->post('location');
        $avail_weight = $this->input->post('avail_weight');
        $out_weight   = $this->input->post('out_weight');
        $last_out_kg  = $this->input->post('last_out_kg');
        $last_dif_kg  = $this->input->post('last_dif_kg');
        $last_out_qty  = $this->input->post('last_out_qty');
        $id_item      = $this->input->post('id_item');
        $id_ts_item      = $this->input->post('id_ts_item');
        $id_bin       = $this->input->post('id_bin');
        $in_code1      = $this->input->post('in_code');
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        // $en_code   = $this->input->post('en_code');
        $note   = $this->input->post('note');
        $submit = $this->input->post('submit');
        //echo $last_out_kg." + ".$out_weight;die();
        $data_ts_item = [
            'id_user'       => $user_id,
            'note'          => $note,
            'out_kg'        => $last_out_kg + $out_weight,
            'dif_kg'         => $last_dif_kg + $out_weight - $avail_weight,
            'out_qty'        => $last_out_qty + 1,
            'is_active'     => 0,
            'last_activity' => date("Y/m/d"),
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            // 'in_code'       => $in_code,
            'out_code'    => $pr_no,
            'id_unit_bin' => $id_bin,
            'id_item'     => $id_item,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => 0,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => $exp_kg,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => 0,
            'status'      => 'PICK',
            'out_kg'      => $out_weight,
            'out_qty'     => 1,
            'dif_kg'      => $out_weight - $avail_weight,
            'dif_qty'     => 0,
            'id_user'     => $user_id,
            'note'        => $note,
        ];

        // echo "<pre>";
        // print_r($data_ts_item);
        // print_r($data_log);
        // print_r($_POST);
        // print_r($this->db->queries);
        // die;

        $this->db->trans_start();
        //update ms_item
        $this->MasterItem->updated_at($id_item);
        // update ts_item
        $this->TransaksiItem->where('id', $id_ts_item)->update($data_ts_item);

        //update ke ms_unit
        //$this->MasterUnit->where('id', $unit->id)->update($data_ms_unit);

        //update ke ms_unit_bin
        // if ($pcs == $avail_qty || $bin_empty == 'on') {
        $this->MasterUnitBin->where('id', $id_bin)->update([
            'id_current_item' => 0,
        ]);
        //}

            // $this->MasterItem->where('id', $id_item)->update(['updated_at', $date_now]);
        // insert log
        $this->MasterItemLog->insert($data_log);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "data gagal";
        }

        if ($submit == 'save') {
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
            // redirect
            redirect('admin_home/paint_pick_new');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }
    
    // find location for put paint
    public function get_location_put_paint()
    {   
        header('Content-Type: application/json');
        $unit        = $this->MasterUnit->where('id', 2)->get();
        $in_weight   = $this->input->post('kg');
        $in_code     = $this->input->post('en_no');
        $item_code   = $this->input->post('item_color_code');
        //$in_weight   = 5;

        //cari lokasi bin yg kosong
        $sql = "SELECT mib.* from ms_unit_bin as mib
                inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                WHERE mib.id_current_item = 0
                and mib.id_unit =2 AND muc.capacity >=$in_weight
                order by mib.code DESC limit 1";

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            echo json_encode([
                'success' => false,
                'msg'     => 'no more space in unit',
            ]);
            die;
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $id_unit_Bin = $unitBin->id;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        //$code_unit_Bin1 = $unitBin->code;
        $kata="Please store item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth ;

        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

        $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        
         echo json_encode([
                'success' => true,
                'msg'     => $kata,
                'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
            ]);

    }

    //insert put paint
    public function insert_put_paint()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('min_text_field', 'Text Field Two', 'required|min_length[8]');

        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('validate_form');
        }
        else
        {
            // load success template...
            echo "It's all Good!";
        }

        date_default_timezone_set('Asia/Jakarta');
        $date_now = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1     = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_weight   = $this->input->post('kg_');
        $submit      = $this->input->post('submit');
        $unit        = $this->MasterUnit->where('id', 2)->get();
        $id_unit_Bin = $this->input->post('id_unit_bin');

        $cek = $this->master_model->cek_paint_exist($in_code1);
        if ($cek != null) {
            echo $cek;
            die;
        }

        // negecek item
        $item = $this->MasterItem
            ->where('code', $item_code)
            ->where('id_category', '2')
            ->get();
        
        if ($item == null) {
            $id_item = $this->MasterItem->getLastId();
        } else {
            $id_item = $item->id;
        }

        $data_item = [
            'id'          => $id_item,
            'id_category' => 2,
            'code'        => $item_code,
            'name'        => "",
            'unit_weight' => 0,
        ];
        

        $exist_ts_item = 1;

        // cek paint sudah pernah ada atau belum
        $sql = "SELECT * FROM ts_item WHERE upper(trim(in_code)) = '".$in_code."'";
        $db_ts_item = $this->db->query($sql)->row();        
            
        if ($db_ts_item == null)
        {
            $exist_ts_item = 0;
            //blm ada
            $id_ts_item = $this->TransaksiItem->getLastId();
            $data_ts_item = [
            // 'id_category'   => 1,
            'id'          => $id_ts_item,
            'in_code'     => $in_code,
            'is_active'   => 1,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => 0,
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => $in_weight,
            'in_qty'      => 1,
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log   = [
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => 0,
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => $in_weight,
            'in_qty'      => 1,
            'id_user'     => $UserName,
            'status'      => 'PUT',
            'note'        => $note,
        ];

    } else {
        //sudah ada 
        $id_ts_item = $db_ts_item->id;
        $in_kg = $db_ts_item->in_kg;
        $in_qty = $db_ts_item->in_qty;
        //$dif_kg = $db_ts_item->dif_kg;
        //$dif_qty = $db_ts_item->dif_qty;

        $data_ts_item = [
            'in_code'     => $in_code,
            'is_active'   => 1,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_Bin,
            'in_kg'       =>  $in_kg + $in_weight,
            'in_qty'      => $in_qty + 1,
            //'dif_kg'        => $dif_kg + $in_weight,
            //'dif_qty'        => $dif_qty + 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];
        $exist_ts_item = 1;

        $data_log   = [
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            //'store_date'  => date("Y-m-d"),
            'unit_weight' => 0,
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => $in_weight,
            'in_qty'      => 1,
            'dif_kg'       => 0,
            'dif_qty'      => 0,
            //'dif_kg'       => $in_weight,
            //'dif_qty'      => 1,
            'id_user'     => $UserName,
            'status'      => 'PUT',
            'note'        => $note,
        ];

    }

        // echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
        // print_r($_POST);
        // die;

        $this->db->trans_start();
        if ($item == null) {
            // insert ke ts_item
            $this->MasterItem->insert($data_item);
        } else {
            //update time stamp master
            $this->MasterItem->updated_at($id_item);
        }
        
        if ($exist_ts_item == 0)
        {
            // insert ke ts_item
        $this->TransaksiItem->insert($data_ts_item);
         } else { //sudah ada update
         // update ts_item
            $this->TransaksiItem->where('id', $id_ts_item)->update($data_ts_item);
        }
        

        // insert ke ts_item_log
        $this->MasterItemLog->insert($data_log);

        $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
            'id_current_item' => $id_ts_item,
        ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
     
        if ($submit == 'save') {
            // redirect
            redirect('admin_home/index/8.php');
            
        }

        if ($submit == 'save_and_put') {
            // redirect
            redirect('admin_home/paint_put_new');
        }
        //echo "successful";


    }

    public function find_pr_pik($pr_no)
    {
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_pr_out($pr_no, 'ts_item_log');
        if ($cek == true) {

            $resp = [
                'status' => 'not_found',
                'result' => [],
            ];

            echo json_encode($resp);
            return;
        }

        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/slider/pick/']);

        // $response = $client->request('GET', $pr_no);

        // $body = $response->getBody();
        // echo $body;
        // $resp = [
        //         'ITEM_CODE'      => '1100750',
        //         'ITEM_NAME'      => '05 CN DA8L ET PARTS',
        //         'CREATE_DATE'    => "2020-05-08",
        //         'UNIT_WEIGHT'    => "0.005039",
        //         // 'EXP_WEIGHT_KG'  => "19.309448",
        //         'EXP_WEIGHT_KG'  => "1.9309",
        //         'EXP_QTY'        => "383",
        //     ];
        $resp = [
                'ITEM_CODE'      => '1100750x',
                'ITEM_NAME'      => '05 CN DA8L ET PARTS RUBBER',
                'CREATE_DATE'    => "2020-05-08",
                'UNIT_WEIGHT'    => "0.5",
                // 'EXP_WEIGHT_KG'  => "19.309448",
                'EXP_WEIGHT_KG'  => "0.5",
                'EXP_QTY'        => "500",
            ];

            echo json_encode($resp);
            return;
    }

    public function index()
    {
        $UserID = $this->session->userdata('id');
        $data['read_rights'] = 1;
        $data['read_rightp'] = 1;
            // $data['read_rights'] = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 10)->check();
            // $data['read_rightp'] = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 11)->check();
        $data['small_bin']   = $this->master_model->small_bin();
        $data['normal_bin']  = $this->master_model->normal_bin();
        $data['paint_bin']         = $this->master_model->paint_bin();
        $data['total_small_bin']   = $this->master_model->total_small_bin();
        $data['total_normal_bin']  = $this->master_model->total_normal_bin();
        $data['total_paint_bin']   = $this->master_model->total_paint_bin();
        // $cek_akses = $this->master_model->cek_pr_out($pr_no, 'user_group_detail');
        // $unit1 = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 10);
        $id_gu = $this->session->userdata('id_user_group');
            $dt_menu = $this->master_model->ms_menu_2(8, $id_gu);
          //$dt_menu = $this->master_model->ms_menu_1(8);
           $read_flga =[];
           $create_flga =[];
           $nm_a = [];
         for($a=0; $a < count($dt_menu); $a++){
            $id_m = $dt_menu[$a]->idm;
            $nm_a[] = $dt_menu[$a]->name;
            $nm_flg[] = $dt_menu[$a]->read_flg;
            $data['nm'] = $nm_a;
             //echo "<pre>";
            // echo "$id_m";
               $read_flga1 = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = $id_m)->check();
               // if($read_flga1 == ""){
               //      $fn = 2;                        
               // } else {
               //     $fn = 1;
               // }
                 $read_flga[] = [
                                 'noput' => $read_flga1,
                                 ];
               $putr1[] = $read_flga1;
                
               $data['putr'] = $read_flga;
            // $data['read_flga']   = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = $id_m)->check();
            $create_flga[] = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = $id_m)->check();
            $data['pickc'] = $create_flga;
         }
         

        //echo "<pre>";
                $data['put_slider']  = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 40)->check();
                $data['pick_slider'] = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 40)->check();

                $data['put_paint']   = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 41)->check();
                $data['pick_paint']  = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 41)->check();

                $data['put_psemple']  = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 42)->check();
                $data['pick_psemple'] = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 42)->check();

                $data['put_rs']      = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 43)->check();
                $data['pick_rs']     = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 43)->check();

                $data['put_sprt']    = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 44)->check();
                $data['pick_sprt']   = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 44)->check();

                $data['put_molding']  = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 45)->check();            
                $data['pick_molding'] = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 45)->check();

                $data['put_mdcm'] = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 46)->check();
                $data['put_mdcd'] = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 47)->check();
                $data['put_mrm']  = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 48)->check();
                $data['put_maso'] = $this->Admin_user_model->auth($UserID)->hasRead($menu_id = 49)->check();

                $data['pick_mdcm'] = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 46)->check();
                $data['pick_mdcd'] = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 47)->check();
                $data['pick_mrm']  = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 48)->check();
                $data['pick_maso'] = $this->Admin_user_model->auth($UserID)->hasCreate($menu_id = 49)->check();
        // echo "<pre>";
        //  print_r($data);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_home';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_home', $data);
    }

    ////////////////////////////////////////////////////////////////////////////
    public function put_new()
    {

        $UserID = $this->session->userdata('id');
        // print_r($UserID);
        // die();

        $data['small_bin']   = $this->master_model->small_bin();
        $data['normal_bin']  = $this->master_model->normal_bin();
        $data['paint_bin']         = $this->master_model->paint_bin();
        $data['total_small_bin']   = $this->master_model->total_small_bin();
        $data['total_normal_bin']  = $this->master_model->total_normal_bin();
        $data['total_paint_bin']   = $this->master_model->total_paint_bin();
        $data['mesin']   = $this->master_model->mesin();
        $data['active'] = 'admin_put';
        // print_r($data['mesin']);
        // die();
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_put', $data);
    }

        // find location for put slider
    public function get_location_put_slider()
    {
        header('Content-Type: application/json');
        $in_kg       = $this->input->post('kg');
        $in_code     = $this->input->post('pr_no');
        $item_code   = $this->input->post('item_code');
        //$in_kg       = "19.309448";

        $category    = 3;
        $mesin       = $this->input->post('mesin');
        $unit        = $this->MasterUnit->where('id', $mesin)->get();
                // $unit        = $this->MasterUnit->where('id', 1)->get();
        $balance_limit        =$unit->balance_limit;
        $tolerance        =$unit->tolerance;
        $shelf       = $unit->shelf;
        $pos_bal = 0;
        $last_position = $this->master_model->find_last_position();
        // echo "<pre>";
        // print_r($unit);
        //  die();
        
        //untuk brg krg dr 2 kg
        if ($in_kg < 2)
        {
            $sql = "SELECT mib.* from ms_unit_bin as mib
                        inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                        WHERE mib.id_current_item = 0  
                        and mib.id_unit =$mesin AND muc.capacity >=$in_kg
                        order by mib.code ASC limit 1";

            $unitBin = $this->db->query($sql)->row();    
        }

        //brg diatas 2kg kaidah balance
        
        if ($in_kg >= 2 && $last_position == 'kiri' && ($unit->balance_weight1  <= ($unit->balance_weight2 + $tolerance )) || ($in_kg >= 2 && $last_position == 'kanan' && (($unit->balance_weight1 + $tolerance ) <= $unit->balance_weight2 )))  {


            $start = 1;
            $end   = $shelf / 2;

            //cari lokasi bin yg kosong di kiriid_unit_bin
            $sql = "SELECT mib.* from ms_unit_bin as mib
                    inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                    WHERE mib.id_current_item = 0
                    AND mib.shelf >=$start 
                    AND mib.shelf <=$end   
                    and mib.id_unit =$mesin AND muc.capacity >=$in_kg
                    order by mib.code ASC limit 1";

            $unitBin = $this->db->query($sql)->row();

            if ($unitBin == null) { // cari sebelah kanan
                $start = ($shelf / 2) + 1;
                $end   = $shelf;

                $sql = "SELECT mib.* from ms_unit_bin as mib
                        inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                        WHERE mib.id_current_item = 0
                        AND mib.shelf >=$start 
                        AND mib.shelf <=$end   
                        and mib.id_unit =$mesin AND muc.capacity >=$in_kg
                        order by mib.code ASC limit 1";

                $unitBin = $this->db->query($sql)->row();
                if ($unitBin == null) { //tidak ketemu sama sekali
                    echo json_encode([
                        'success' => false,
                        'msg'     => 'no more space in unit',
                    ]);
                    die;
                } else {
                    $pos_bal = 2;
                }
            } else {
                $pos_bal = 1;
            }
            
        } else { // kanan
            $start = ($shelf / 2) + 1;
            $end   = $shelf;

            $sql = "SELECT mib.* from ms_unit_bin as mib
                    inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                    WHERE mib.id_current_item = 0
                    AND mib.shelf >=$start 
                    AND mib.shelf <=$end   
                    and mib.id_unit =$mesin AND muc.capacity >=$in_kg
                    order by mib.code ASC limit 1";

            $unitBin = $this->db->query($sql)->row();
           if ($unitBin == null) { // cari sebelah kiri
                $start =  1;
                $end   = $shelf / 2;

                $sql = "SELECT mib.* from ms_unit_bin as mib
                        inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                        WHERE mib.id_current_item = 0
                        AND mib.shelf >=$start 
                        AND mib.shelf <=$end   
                        and mib.id_unit =$mesin AND muc.capacity >=$in_kg
                        order by mib.code ASC limit 1";

                $unitBin = $this->db->query($sql)->row();
                
                if ($unitBin == null) { //tidak ketemu sama sekali
                   echo json_encode([
                        'success' => false,
                        'msg'     => 'no more space in unit',
                    ]);
                    die;
                } else {
                    $pos_bal = 1;
                }
            } else {
                $pos_bal = 2;
            }
        }

        if ($unitBin != null) { //gerakan rotator dan message
            $ip                   = $unit->ip;
            $port                 = $unit->port;
            $unit_bin_shelf       = $unitBin->shelf;
            $unit_bin_compartment = $unitBin->compartment;
            $static_depth         = $unit->static_depth;
            if ($static_depth == 0) {
                $unit_bin_depth       = $unitBin->depth;
            } else {
                $unit_bin_depth = $static_depth;
            }

            $kata="Please store item on shelf : " .$unit_bin_shelf . " and depth : ". $unit_bin_depth . " and compartment no : ". $unit_bin_compartment;
            

                // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
                // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code. '&desc3='. $in_kg .'';


                // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

                // $resp = $client->request('GET', $playload);
            // echo $base_url . $playload;
            // echo "<br>";
            // echo $resp->getBody();
            //die;
             echo json_encode([
                'success' => true,
                'msg'     => $kata,
                    //'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
                'pos_bal'  => $pos_bal,
            ]);
        }

    }

//insert put slider
    public function insert_put()
    {
        date_default_timezone_set('Asia/Jakarta');
        $date_now = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $create_date = $this->input->post('create_date');
        $submit      = $this->input->post('submit');
        $in_code1     = strtoupper(trim($this->input->post('pr_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_code')));
        $item_name   = $this->input->post('item_name');
        $unit_weight = $this->input->post('unit_weight');
        $exp_qty     = $this->input->post('exp_qty');
        $exp_kg      = $this->input->post('exp_kg');
        $in_qty      = $this->input->post('pcs');
        $in_kg       = $this->input->post('kg');
        $pos_bal     = $this->input->post('pos_bal');
        $id_unit_bin = $this->input->post('id_unit_bin');
        $dasaran     = $this->input->post('tipe');
        if($dasaran == 'on'){
            // $is_dasaran = 1;
            $is_dasaran = 0;
        } else {
            $is_dasaran = 0;
        }

        $mesin     = $this->input->post('mesin');
        $unit        = $this->MasterUnit->where('id', $mesin)->get();
            // $unit        = $this->MasterUnit->where('id', 1)->get();
         $category    = 1;
        // $UserName    = '1';
        // $note        = "test";
        // $create_date = "2020-05-08";
        // $submit      = "save_and_put";
        // $in_code     = "PR02271710";
        // $item_code   = "1100750";
        // $item_name   = "05 CN DA8L ET PARTS";
        // $unit_weight = "0.005039";
        // $exp_qty     = "3832";
        // $exp_kg      = "19.309448";
        // $in_qty      = "3832";
        // $in_kg       = "19.309448";
        
        //echo $last_position;
        
        $item = $this->MasterItem
            ->where('code', $item_code)
            ->where('name', $item_name)
            ->where('id_category', $category)
            ->get();
   
        if ($item == null) {
            $id_item = $this->MasterItem->getLastId();
        } else {
            $id_item = $item->id;
        }

        $data_item = [
            'id'          => $id_item,
            'id_category' => 1,
            'code'        => $item_code,
            'name'        => $item_name,
            'unit_weight' => $unit_weight,
        ];
        $id_ts_item = $this->TransaksiItem->getLastId();
        $data_log   = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => $unit_weight,
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            'in_kg'       => $in_kg,
            'in_qty'      => $in_qty,
            'bal_kg'       => $in_kg,
            'bal_qty'      => $in_qty,
            'id_user'     => $UserName,
            'status'      => 'PUT',
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            // 'is_active' => $item_name,
            'note'        => $note,
            'is_dasaran'  => $is_dasaran,
        ];

        $data_ts_item = [
            // 'id_category'   => 1,
            'id'          => $id_ts_item,
            'in_code'     => $in_code,
            'is_active'   => 1,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => $unit_weight,
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            'in_kg'       => $in_kg,
            'in_qty'      => $in_qty,
            //'updated_at'  => $date_now,
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            'id_user'     => $UserName,
            'note'        => $note,
            'is_dasaran'  => $is_dasaran,
        ];

        //echo "<pre>";
        //print_r([$item, $data_item, $data_log, $data_ts_item]);
         //print_r($data_log);
         //print_r($data_item);
        //print_r($_POST);
        //echo "<pre>";
        // echo $pos_bal;
        // echo "<br>";
        //echo $id_nilai = $unit->balance_weight1 + $in_kg;
        // echo "<br>";
        // echo $id_nilai2 = $unit->balance_weight2 + $in_kg;
        //die;

        $this->db->trans_start();
        if ($item == null) {
            // insert ke ts_item
            $this->MasterItem->insert($data_item);
        } else {
            $this->MasterItem->updated_at($id_item);
            //$this->MasterItem->where('id', $id_item)->update('updated_at',$date_now);
            // $where = array('id' => $id_item);
            // $data['user'] = $this->master_model->edit_data($where,'updated_at')->result();
        }

        // insert ke ts_item
        $this->TransaksiItem->insert($data_ts_item);

        // insert ke ts_item_log
        $this->MasterItemLog->insert($data_log);

        if ($pos_bal == 1) {
            $this->MasterUnit->where('id', $unit->id)->update([
                'balance_weight1' => $unit->balance_weight1 + $in_kg,
            ]);
        } else {
            $this->MasterUnit->where('id', $unit->id)->update([
                'balance_weight2' => $unit->balance_weight2 + $in_kg,
            ]);
        }

        $this->MasterUnitBin->where('id', $id_unit_bin)->update([
            'id_current_item' => $id_ts_item,
        ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
       
        if ($submit == 'save') {
            // redirect
             $this->session->set_flashdata('messages', 'Add data PUT Slider succes');
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_put') {
            // redirect
             $this->session->set_flashdata('messages', 'Add data PUT Slider succes');             
            redirect('admin_home/put_new');
        }
        //echo "successful";
    }

   
    public function check_en()
    {
        //header('Content-Type: application/json');
        $in_code = strtolower($this->input->post('in_code'));
        $en_code = strtolower($this->input->post('en_code'));
        // echo $in_code;
        // echo $en_code;
        if ($in_code == $en_code) {
            echo "Right";
        } else {
            echo "Code is different from " . $in_code;
        }

    }

    //////find paint

    public function find_paint()
    {
        header('Content-Type: application/json');
        $in_weight = $this->input->post('exp_kg');
        if($in_weight == ''){
            $in_weight =0;
        }
        $code      = strtoupper(trim($this->input->post('item_code')));
        $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE (ti.in_kg-ti.out_kg+ti.dif_kg)>='" . $in_weight . "' AND upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =2 ORDER BY ti.store_date ASC")->row();
        // echo json_encode([
        //     'msg'     => 'ok',
        //     'tsItem'  => $data_bin,
        //     'weight'  => $in_weight,
        //     'code'  => $code,
        // ]);
        // die();
        if ($data_bin == null) { //not found try to search next biggest available.
            $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE  upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =2 ORDER BY (ti.in_kg-ti.out_kg+ti.dif_kg) DESC, ti.store_date ASC")->row();
        }

        if ($data_bin == null) {
            $data['msg'] = "Item not found";
                echo json_encode([ 
                'msg' => "Item not found",
                'content' => $this->load->view('admin/get_item_not_avail_html', $data, true),
            ]);
            return;
            die;
        }

        $exp_kg = $data_bin->avail_kg;
        $item_code = $data_bin->code_item;
        $in_code = $data_bin->in_code;
        $ip = $data_bin->ip;
        $port = $data_bin->port;
        $unit_bin_shelf = $data_bin->shelf;
        $unit_bin_compartment = $data_bin->compartment;
        $static_depth         = $data_bin->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $data_bin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        $kata="Please take item on shelf : " .$unit_bin_shelf  . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth;

        // data ketemu
        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';
        
         $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $data_bin,
            'msg' => $kata,
        ];
        echo json_encode([
            'msg' => $kata,
            'tsItem'  => $data_bin,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }

    ///buka mesin pick paint
    public function get_item_avail_open_paint()
    {
        header('Content-Type: application/json');

        $pr_open   = $this->input->post('pr_open');
        
        $category    = 1;

        $tsItem = $total = $this->db->query("
            SELECT
                    mu.static_depth, mi.code as code_item, mi.id as item_id, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.id, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, format((ts_item.in_kg-ts_item.out_kg+ts_item.dif_kg),3 ) as avail_kg, (ts_item.in_qty-ts_item.out_qty+ts_item.dif_qty) as avail_qty
            FROM
                ts_item
            INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
             LEFT join ms_unit as mu ON mu.id = mub.id_unit
             LEFT JOIN ms_item as mi ON mi.id = ts_item.id_item
            WHERE ts_item.is_active = 1 AND
                ts_item.in_code = '" . $pr_open . "'
                
            ")->row();
            $exp_kg = $tsItem->avail_kg;
            $item_code = $tsItem->code_item;
            $in_code = $tsItem->in_code;
            $ip = $tsItem->ip;
            $port = $tsItem->port;
            $unit_bin_shelf = $tsItem->shelf;
            $unit_bin_compartment = $tsItem->compartment;
            $static_depth         = $tsItem->static_depth;
            if ($static_depth == 0) {
                $unit_bin_depth       = $tsItem->depth;
            } else {
                $unit_bin_depth = $static_depth;
            }


        $kata="Please take item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment  . " and depth : ". $unit_bin_depth;

        // data ketemu
        $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
         $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';
        
        $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        $resp = $client->request('GET', $playload);
        //echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $tsItem,
            'msg'     => $kata,
        ];
        echo json_encode([
            //'msg'     => (string) $resp->getBody(),
            'msg'     => $kata,
            'tsItem'  => $tsItem,
            // 'item'    => $item,
            'sql'     => $this->db->queries,
            //'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }


    ///buka mesin pick slider
    public function get_item_avail_open()
    {
        header('Content-Type: application/json');

        $pr_open   = $this->input->post('pr_open');
        
        $category    = 1;

        $tsItem = $total = $this->db->query("
            SELECT
                    mu.static_depth, mi.code as code_item, mi.id as item_id, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.id, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
            FROM
                ts_item
            INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
             LEFT join ms_unit as mu ON mu.id = mub.id_unit
             LEFT JOIN ms_item as mi ON mi.id = ts_item.id_item
            WHERE ts_item.is_active = 1 AND
                ts_item.in_code = '" . $pr_open . "'
                
            ")->row();
        // print_r($tsItem);
        // die();
        $exp_kg = $tsItem->avail_kg;
        $item_code = $tsItem->code_item;
        $in_code = $tsItem->in_code;
        $ip = $tsItem->ip;
        $port = $tsItem->port;
        $unit_bin_shelf = $tsItem->shelf;
        $unit_bin_compartment = $tsItem->compartment;
        $static_depth         = $tsItem->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $tsItem->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        $kata="Please take item on shelf : " .$unit_bin_shelf . " and depth : ". $unit_bin_depth . " and compartment no : ". $unit_bin_compartment;

        // data ketemu
            // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
            //  $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';
            
            // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

            // $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $tsItem,
            'msg'    => $kata,
        ];
        echo json_encode([
            //'msg'     => (string) $resp->getBody(),
            'msg' => $kata,
            'tsItem'  => $tsItem,
            // 'item'    => $item,
            'sql'     => $this->db->queries,
           // 'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }

    //pick slider find
    public function get_item_avail()
    {
        header('Content-Type: application/json');

            //$item_code   = $this->input->post('item_code');
        $exp_kg      = $this->input->post('exp_kg');
        $dasaran     = $this->input->post('dasaran');
        if($dasaran == 'on'){
            $is_dasaran = 1;
        } else {
            $is_dasaran = 0;
        }
        // echo json_encode([
        // 'das' => $dasaran,
        // ]);

        // $item_name   = $this->input->post('item_name');
        // $unit_weight = $this->input->post('unit_weight');
        // $exp_qty     = $this->input->post('exp_qty');
        // $out_qty     = $this->input->post('pcs');
        // $out_kg      = $this->input->post('kg');

        $item_code   = "1100750x";
         //$item_code   = "3412860";    
        // $exp_kg      = "10";
        
        
        $category    = 3;

        $item = $this->MasterItem
            ->where('code', $item_code)
            // ->where('name', $item_name)
            ->where('id_category', $category)
            ->get();

        ///tidak dapat
        if ($item == null) {
            $data['msg'] = "Item not found";
                echo json_encode([
                //'content' => 'Item not found',
                'msg' => "Item not found",
                'content' => $this->load->view('admin/get_item_not_avail_html', $data, true),
            ]);
            return;
            die;
        }

        $id_item = $item->id;
        $mesin = 3;
        // $mesin = $this->input->post('mesin');
        $unit      = $this->MasterUnit->where('id', $mesin)->get();
                //$unit      = $this->MasterUnit->where('id', 1)->get();
        
        //cari dulu di shelf yg sama barang 
        $last_shelf = $this->master_model->find_last_shelf(1);

                // if ($last_shelf !=0) {
                //     $sql = "SELECT
                //             mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
                //     FROM
                //         ts_item
                //     INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
                //      LEFT join ms_unit as mu ON mu.id = mub.id_unit
                //     WHERE ts_item.is_active = 1 AND
                //         ts_item.id_item = '" . $item->id . "' AND mub.id_unit = $mesin AND
                //         mub.shelf =  '" . $last_shelf . "'  AND
                //         (in_kg-out_kg-dif_kg) >= '" . $exp_kg . "'
                //         ORDER BY  (in_kg-out_kg-dif_kg) ASC, ts_item.id ASC LIMIT 1";

                //     $tsItem = $total = $this->db->query($sql)->row();
                // } else { //tdk ketemu di shelf yg sama
                //     $tsItem == null;
                // }
                
                
                // //cari posisi akhir dimana.. kiri atau kanan.
                // $last_position = $this->master_model->find_last_position();
                // $tolerance = $unit->tolerance;

                // if ($tsItem == null && ($last_position == 'kiri' && (($unit->balance_weight1  + $tolerance)  >= $unit->balance_weight2) || ($last_position == 'kanan' && ($unit->balance_weight1 >= ($unit->balance_weight2 + $tolerance ) ))))  {

                // // if ($unit->balance_weight1 >= $unit->balance_weight2) {
                //     //  'cari ke kiri yg lbh berat
                //     $start_shelf = 1;
                //     $end_shelf   = 29;
                //     $found_pos   = 1; // kiri
                // } else {
                //     //  'cari ke kanan yg lbh berat
                //     $start_shelf = 30;
                //     $end_shelf   = 58;
                //     $found_pos   = 2; // kanan
                // }

                // $tsItem = $total = $this->db->query("
                //     SELECT
                //             mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
                //     FROM
                //         ts_item
                //     INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
                //      LEFT join ms_unit as mu ON mu.id = mub.id_unit
                //     WHERE ts_item.is_active = 1 AND mub.id_unit = $mesin AND
                //         ts_item.id_item = '" . $item->id . "' AND
                //         mub.shelf >= '" . $start_shelf . "' AND
                //         mub.shelf <=  '" . $end_shelf . "'  AND
                //         (in_kg-out_kg-dif_kg) >= '" . $exp_kg . "'
                //         ORDER BY  (in_kg-out_kg-dif_kg) ASC, ts_item.id ASC, mub.code ASC  LIMIT 1
                //     ")->row();

                // if ($tsItem == null) { // not found move to other side
                //     // 'cari di balik ke-2
                //     if ($unit->balance_weight1 >= $unit->balance_weight2) {
                //         $start_shelf = 30;
                //         $end_shelf   = 58;
                //         $found_pos   = 2; //kanan
                //     } else {
                //         $start_shelf = 1;
                //         $end_shelf   = 29;
                //         $found_pos   = 1; // kiri
                //     }

                //     $tsItem = $total = $this->db->query("
                //         SELECT
                //            mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, ts_item.in_code, mub.compartment, mub.depth, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
                //         FROM
                //             ts_item
                //         INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
                //         LEFT join ms_unit as mu ON mu.id = mub.id_unit
                //         WHERE ts_item.is_active = 1 AND mub.id_unit = $mesin AND
                //             ts_item.id_item = '" . $item->id . "' AND
                //             mub.shelf >= '" . $start_shelf . "' AND
                //             mub.shelf <=  '" . $end_shelf . "'  AND
                //             (in_kg-out_kg-dif_kg) >= '" . $exp_kg . "'
                //             ORDER BY  (in_kg-out_kg-dif_kg) ASC, ts_item.id ASC, mub.code ASC  LIMIT 1
                //     ")->row();

                //     // if not found find the biggest stock available
                //     if ($tsItem == null) {
                //         $sql = "SELECT
                //                 mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
                //         FROM
                //             ts_item
                //         INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
                //          LEFT join ms_unit as mu ON mu.id = mub.id_unit
                //         WHERE ts_item.is_active = 1 AND
                //             ts_item.id_item = '" . $item->id . "' AND mub.id_unit = $mesin 
                //             ORDER BY  (in_kg-out_kg-dif_kg) DESC, ts_item.id DESC LIMIT 1";

                //         $tsItem = $total = $this->db->query($sql)->row();
                //     }
                // }


        //iqnore formula lama langsung cari lagi yg terkecil aja ambilnya.
         $sql = "SELECT
                        mu.static_depth, mu.ip,mu.port, mub.code, mub.shelf, mub.compartment, mub.depth, ts_item.in_code, ts_item.out_kg, ts_item.in_kg, ts_item.dif_kg, ts_item.in_qty, ts_item.out_qty, ts_item.dif_qty, ts_item.id as ts_item_id, mub.id as ms_unit_bin_id, (ts_item.in_kg-ts_item.out_kg-ts_item.dif_kg) as avail_kg, (ts_item.in_qty-ts_item.out_qty-ts_item.dif_qty) as avail_qty
                FROM
                    ts_item
                INNER JOIN ms_unit_bin as mub ON mub.id = ts_item.id_unit_bin
                 LEFT join ms_unit as mu ON mu.id = mub.id_unit
                    WHERE 
                    ts_item.is_active = 1 
                    AND ts_item.is_dasaran = $is_dasaran
                    AND ts_item.id_item = '" . $item->id . "' AND mub.id_unit = $mesin 
                        ORDER BY  (in_kg-out_kg-dif_kg) ASC, ts_item.id ASC LIMIT 1";
        // echo json_encode([
        // 'content' => $sql,
        // ]);

        $tsItem = $total = $this->db->query($sql)->row();

        if ($tsItem != null) { // found 
            $in_code = $tsItem->in_code;
            $ip = $tsItem->ip;
            $port = $tsItem->port;
            $unit_bin_shelf = $tsItem->shelf;
            $static_depth = $tsItem->static_depth;
            $unit_bin_compartment = $tsItem->compartment;
            if ($static_depth == 0) {
                $unit_bin_depth       = $tsItem->depth;
            } else {
                $unit_bin_depth = $static_depth;
            }
        }
    
        
        // echo $tsItem;
        // die();
        if ($tsItem == null) {
            $data['msg'] = "Item not Avalaibe";
                echo json_encode([
                //'content' => 'Item not found',
                'msg' => "Item not Avalaibe",
                'content' => $this->load->view('admin/get_item_not_avail_html', $data, true),
            ]);
            return;
            die;
        }

        $kata="Please take item on shelf : " .$unit_bin_shelf . " and depth : ". $unit_bin_depth . " and compartment no : ". $unit_bin_compartment;

        // data ketemu
            //$base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';

            // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

            //$resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $tsItem,
            'msg'     => $kata,
        ];
        echo json_encode([
            //'msg'     => (string) $resp->getBody(),
            'msg'     => $kata,
            'tsItem'  => $tsItem,
            'item'    => $item,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }

    //insert pick slider
    public function insert_pick()
    {
        date_default_timezone_set('Asia/Jakarta');
        $date_now = date('Y-m-d h:i:s');
        $submit         = $this->input->post('submit');
        $user_id        = $this->session->userdata('id');
        $note           = $this->input->post('note');
        $bin_empty      = $this->input->post('publish');
        $in_code1        = strtoupper(trim($this->input->post('pr_no')));
        $in_code        = $this->MasterItem->clean_in_code($in_code1);
        $item_code      = strtoupper(trim($this->input->post('item_code')));
        $item_name      = $this->input->post('item_name');
        $unit_weight    = $this->input->post('unit_weight');
        $exp_qty        = $this->input->post('exp_qty');
        $exp_kg         = $this->input->post('exp_kg');
        $avail_qty      = $this->input->post('avail_qty');
        $avail_kg       = $this->input->post('avail_kg');
        $pcs            = $this->input->post('pcs');
        $kg             = $this->input->post('kg');
        $id_item        = $this->input->post('item_id');
        $ms_unit_bin_id = $this->input->post('ms_unit_bin_id');
        $category       = 1;
        $dasaran     = $this->input->post('tipe');
        if($dasaran == 'on'){
            //$is_dasaran = 1;
            $is_dasaran = 0;
        } else {
            $is_dasaran = 0;
        }

             $mesin  = $this->input->post('mesin');
             $unit   = $this->MasterUnit->where('id', $mesin)->get();
            //$unit    = $this->MasterUnit->where('id', 1)->get();
        $unitBin = $this->MasterUnitBin->where('id', $ms_unit_bin_id)->get();
        $tsItem  = $this->TransaksiItem->where('id', $unitBin->id_current_item)->get();
        $dif_qty = 0;
        $dif_kg  = 0;
        $out_kg  = $tsItem->out_kg + $kg;
        $out_qty = $tsItem->out_qty + $pcs;

        // maka habis
        if ($pcs == $avail_qty) {
            $data_ts_item = [
                'id_user'       => $user_id,
                'note'          => $note,
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'is_active'     => 0,
                'last_activity' => date("Y/m/d"),
            ];
        } else {
            $data_ts_item = [
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'is_active'     => 1,
                'last_activity' => date("Y/m/d"),
                'id_user'       => $user_id,
                'note'          => $note,
            ];
        }

        //' ambil semua
        if ($bin_empty == 'on') {
            $dif_qty = $tsItem->dif_qty + ($pcs - $avail_qty);
            $dif_kg  = $tsItem->dif_kg + ($kg - $avail_kg);

            $data_ts_item = [
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'dif_qty'       => $dif_qty,
                'dif_kg'        => $dif_kg,
                'is_active'     => 0,
                'last_activity' => date("Y/m/d"),
                'id_user'       => $user_id,
                //'updated_at'    => $date_now,
                'note'          => $note,
            ];
        }

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $tsItem->id,
            // 'in_code'       => $in_code,
            'out_code'    => $in_code,
            'id_unit_bin' => $ms_unit_bin_id,
            'id_item'     => $id_item,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $unit_weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            // 'in_kg'    => $in_kg,
            // 'in_qty'   => $in_qty,
            'status'      => 'PICK',
            'out_kg'      => $kg,
            'out_qty'     => $pcs,
            'bal_kg'      =>  $avail_kg - $kg,
            'bal_qty'     =>  $avail_pcs - $pcs,
            'dif_kg'      => $dif_kg,
            'dif_qty'     => $dif_qty,
            'id_user'     => $user_id,
            'note'        => $note,
            'is_dasaran'  => $is_dasaran,
        ];

        if ($unitBin->shelf <= ($unit->shelf / 2)) {
            //  'kiri
            $data_ms_unit = [
                'balance_weight1' => $unit->balance_weight1 - $kg,
            ];
        } else {
            //  'kanan
            $data_ms_unit = [
                'balance_weight2' => $unit->balance_weight2 - $kg,
            ];
        }

        echo "<pre>";
         print_r($_POST);
         print_r($data_ts_item);
        // print_r($tsItem);
        // print_r($data_log);
        // print_r($this->db->queries);
         die;

        $this->db->trans_start();
        //update master item
        $this->MasterItem->updated_at($id_item);
        // update ts_item
        $this->TransaksiItem->where('id', $tsItem->id)->update($data_ts_item);

        //update ke ms_unit
        $this->MasterUnit->where('id', $unit->id)->update($data_ms_unit);

        //update ke ms_unit_bin
        if ($pcs == $avail_qty || $bin_empty == 'on') {
            $this->MasterUnitBin->where('id', $ms_unit_bin_id)->update([
                'id_current_item' => 0,
            ]);
        }

        

        // insert log
        $this->MasterItemLog->insert($data_log);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "data gagal";
        }

        if ($submit == 'save') {
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
            // redirect
            redirect('admin_home/pick_new');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }

    
    ////////////////////////////////////////////////////////////////////////////

    public function pick_new()
    {
        $this->Admin_user_model->auth()->hasUpdate($menu_id = 5)->redirect('/admin_by_category/list');
        $UserID = $this->session->userdata('id');
        @$PR_ID = $this->uri->segment(3);
        if ($PR_ID != '') {
            $sql = "SELECT (ti.in_qty-ti.out_qty+ti.dif_qty) as exp_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as exp_kg, (ti.in_qty-ti.out_qty+ti.dif_qty) as avail_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg, mub.id_unit, mub.code as codeb, mub.id as id_unit_bin, mi.code, mi.name, mi.unit_weight, mi.id as id_item, ti.is_dasaran 
        FROM ts_item AS ti 
        LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         LEFT join ms_item as mi ON mi.id = ti.id_item
         WHERE ti.in_code='" . $PR_ID . "' ";
            $qry               = $this->db->query($sql);
            $row               = $qry->result_array();
            $data['data_pick'] = $row;
            // echo "<pre>";
            // print_r($row);
            // die;
        }
        $data['last_mt'] = $this->master_model->mst_last_np('ts_item_log','NP');

        $data['mesin']   = $this->master_model->mesin();
        // print_r($data['data_pick']);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_pick';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_pick', $data);
    }

    ////////////////////////////////////////////////////////////////////////////

    public function pick($id)
    {

        $UserID = $this->session->userdata('id');
        $sql    = "SELECT ti.*, mub.code as codeb, mi.code, mi.name FROM ts_item AS ti LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         LEFT join ms_item as mi ON mi.id = ti.id_item
         WHERE ti.in_code='" . $id . "' ";
        $qry               = $this->db->query($sql);
        $row               = $qry->result_array();
        $data['data_pick'] = $row;
        // echo "<pre>";
        // print_r($data['data_pick']);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_pick';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_pick_1', $data);
    }

    ////////////////////////////////////////////////////////////////////////////
    public function sparepart_put_new()
    {

        $UserID = $this->session->userdata('id');
        // print_r($UserID);
        // die();
        $data['paint_bin']       = $this->master_model->paint_bin();
        $data['total_paint_bin']       = $this->master_model->total_paint_bin();
        $data['active'] = 'admin_spareparts_put';       

        $this->load->view('admin/admin_spareparts_put', $data);
    }

    public function paint_put_new()
    {

        $UserID = $this->session->userdata('id');
        // print_r($UserID);
        // die();
        $data['paint_bin']       = $this->master_model->paint_bin();
        $data['total_paint_bin']       = $this->master_model->total_paint_bin();
        $data['active'] = 'admin_paints_put';       

        $this->load->view('admin/admin_paints_put', $data);
    }

    public function paint_pick_new()
    {

        $UserID = $this->session->userdata('id');
        @$PR_ID = $this->uri->segment(3);
        if ($PR_ID != '') {
         //    $sql = "SELECT (ti.in_qty-ti.out_qty+ti.dif_qty) as exp_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as exp_kg, mub.code as codeb, mi.code, mi.name FROM ts_item AS ti LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         // LEFT join ms_item as mi ON mi.id = ti.id_item
         // WHERE ti.in_code='" . $PR_ID . "' ";
            $sql = "SELECT (ti.in_qty-ti.out_qty+ti.dif_qty) as exp_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as exp_kg, (ti.in_qty-ti.out_qty+ti.dif_qty) as avail_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  mub.code as codeb, mi.code, mi.name, mi.unit_weight FROM ts_item AS ti LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         LEFT join ms_item as mi ON mi.id = ti.id_item
         WHERE ti.in_code='" . $PR_ID . "' ";
            $qry               = $this->db->query($sql);
            $row               = $qry->result_array();
            $data['data_pick'] = $row;
            $data_da           = $row;
        }
        
        $data['last_mt'] = $this->master_model->mst_last_np('ts_item_log','NP');
        $data['codel'] = @$row['0']['code'];
        $data['avail_kg'] = @$row['0']['avail_kg'];
        
        
        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_paints_pick';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/admin_paints_pick', $data);
    }

    /////////////////////////////////////////////////////////////////////

    public function check_code_unit()
    {
        $code = $this->input->post('pr_no');
        // echo $code;
        // die();
        $cek = $this->master_model->cek_pr1($code, 'ts_item');

        if ($cek) {
            echo '0';
        } else {
            echo '1';
        }
    }

    public function check_code_unit_out()
    {
        $code = $this->input->post('pr_no');
        // echo $code;
        // die();
        $cek = $this->master_model->cek_pr_out($code, 'ts_item_log');

        if ($cek) {
            echo '0';
        } else {
            echo '1';
        }
    }

    ///////////////////////////////////////////////////////////////////////

    public function edit_process($MENU_ID, $AboutID)
    {

        $PublishFlg = 0;

        $CekImage = $this->admin_about_model->CekImage($AboutID);
        $Cek      = $CekImage[0]['Image'];

        if ($this->input->post('PublishFlg') == 'on') {
            $PublishFlg = 1;
        }

        if ($this->input->post('ImageType') != '') {
            if ($this->input->post('ImageType') == 'NoImage') {
                if ($Cek != "") {
                    unlink('./uploads/about/' . $Cek);
                }
                $ImageName = "";
            } else if ($this->input->post('ImageType') == 'UploadNew') {
                $ImageName = $AboutID . '.' . substr($_FILES['ImageUpload']['name'], strrpos($_FILES['ImageUpload']['name'], '.') + 1);

                if ($Cek != "") {
                    unlink('./uploads/about/' . $Cek);
                }
                $this->uploadImage($AboutID);
            } else if ($this->input->post('ImageType') == 'SelectList') {
                $ImageName = $this->input->post('ImageCurrent');
            }

            $data = array(
                'AboutName'   => $this->input->post('Name'),
                'E_AboutName' => $this->input->post('E_Name'),
                'ShortDesc'   => $this->input->post('ShortDesc'),
                'E_ShortDesc' => $this->input->post('E_ShortDesc'),
                'LongDesc'    => $this->input->post('LongDesc'),
                'E_LongDesc'  => $this->input->post('E_LongDesc'),
                'Image'       => $ImageName,
                'PublishFlg'  => $PublishFlg,
            );
        } else {
            $data = array(
                'AboutName'   => $this->input->post('Name'),
                'E_AboutName' => $this->input->post('E_Name'),
                'ShortDesc'   => $this->input->post('ShortDesc'),
                'E_ShortDesc' => $this->input->post('E_ShortDesc'),
                'LongDesc'    => $this->input->post('LongDesc'),
                'E_LongDesc'  => $this->input->post('E_LongDesc'),
                'PublishFlg'  => $PublishFlg,
            );
        }

        $this->db->where('AboutID', $AboutID);
        $this->db->update('about', $data);

        redirect('admin_about/index/' . $MENU_ID);

    }

    public function uploadImage($AboutID)
    {
        $config['file_name']     = $AboutID;
        $config['upload_path']   = './uploads/about';
        $config['allowed_types'] = 'gif|jpg|png';
        $config['max_size']      = '100';
        $config['max_width']     = '1024';
        $config['max_height']    = '768';

        $this->load->library('upload', $config);
        $this->upload->do_upload('ImageUpload');
    }

    public function clear_data(){
        $UserID = $this->session->userdata('id');

        // echo "come soon";
        // die;
        if($UserID == '1'){           
        
            $sql = "DELETE  FROM ts_item_log"; 
            $sql2 = "DELETE  FROM ts_item";
            $sql3 = "DELETE  FROM ms_item";
            $sql4 = "ALTER TABLE ts_item_log AUTO_INCREMENT = 1"; 
            $sql5 = "ALTER TABLE ts_item  AUTO_INCREMENT = 1";
            $sql6 = "ALTER TABLE ms_item  AUTO_INCREMENT = 1";
            $sql7 = "UPDATE ms_unit SET balance_weight1 = 0, balance_weight2 = 0";
            $sql8 = "update ms_unit_bin set id_current_item = 0";
            $qry = $this->db->query($sql); $this->db->query($sql2);$this->db->query($sql3);$this->db->query($sql4);$this->db->query($sql5);$this->db->query($sql6);$this->db->query($sql7);$this->db->query($sql8);
            $this->session->set_flashdata('message','Success');
            redirect('admin_home');
       } else {
        $this->session->set_flashdata('message','No Access');
        redirect('admin_home');
       }
        //return $qry;
        redirect('admin_home');
    }

    public function sparepart_pick_new($pr)
    {
         $UserID = $this->session->userdata('id');
        // print_r($pr);
        // die();
        $data['paint_bin']       = $this->master_model->paint_bin();
        $data['total_paint_bin']       = $this->master_model->total_paint_bin();
        $data['active'] = 'admin_spareparts_pik';       
            if($pr == "md"){
                $this->load->view('admin/admin_spareparts_pik_md', $data);
            } else {
                $this->load->view('admin/admin_spareparts_pik_disposal', $data);
            }
        
    }

    ////////////////////////////////////////////////////////////////////////////
    public function molding_put_new($pr)
    {

        $UserID = $this->session->userdata('id');        
        $ID = 6;
        $data['paint_bin']       = $this->master_model->paint_bin();
        $data['total_paint_bin']       = $this->master_model->total_paint_bin();
         //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID group by ANY_VALUE(code)");
          // $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID group by code"); 
        $data['active'] = 'admin_molding_put';   
        

        if($pr == 'dm'){
            //$ID = 6;
            $idc = 9;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            // echo "<pre>";
        // print_r($data['ms_item']);
        // die();    
            $this->load->view('admin/molding/admin_molding_put_dm', $data);

        } else if ($pr == 'dd'){
            //$ID = 6;
            $idc = 10;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            $this->load->view('admin/molding/admin_molding_put_dd', $data);

        } else if($pr == 'rm'){
            //$ID = 6;
            $idc = 11;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            $this->load->view('admin/molding/admin_molding_put_rm', $data);

        } else if($pr == 'as'){
            $ID = 6;
            $idc = 12;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            $this->load->view('admin/molding/admin_molding_put_as', $data);

        }
        // $this->session->set_flashdata('message','No Access');
        // redirect('admin_home');
    }

    ////////////////////////////////////////////////////////////////////////////
    public function molding_pick_new($pr)
    {

        $UserID = $this->session->userdata('id');
        // print_r($pr);
        // die();
        $ID = 6;
        $data['paint_bin']       = $this->master_model->paint_bin();
        $data['total_paint_bin']       = $this->master_model->total_paint_bin();
        $data['active'] = 'admin_molding_pick';  
        $data['ts_item'] = $this->master_model->select_in('ts_item','id, in_code, id_unit_bin',""); 
        //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID group by ANY_VALUE(code)");
         $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID group by code");    

        if($pr == 'dm'){
            $idc = 9;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            $this->load->view('admin/molding/admin_molding_pick_dm', $data);

        } else if ($pr == 'dd'){
            $idc = 10;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            $this->load->view('admin/molding/admin_molding_pick_dd', $data);

        } else if($pr == 'rm'){
            $idc = 11;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            $this->load->view('admin/molding/admin_molding_pick_rm', $data);

        } else if($pr == 'as'){
            $idc = 12;
            //$data['ms_item'] = $this->master_model->select_in('ms_item','ANY_VALUE(id) as id, ANY_VALUE(code) as code, ANY_VALUE(name) as name',"WHERE id_category = $ID and id_capacity = $idc group by ANY_VALUE(code)"); 
            $data['ms_item'] = $this->master_model->select_in('ms_item','id as id, code as code, name as name',"WHERE id_category = $ID and id_capacity = $idc group by code");
            $this->load->view('admin/molding/admin_molding_pick_as', $data);

        }
        // $this->session->set_flashdata('message','No Access');
        // redirect('admin_home');
    }

    public function sample_put_new()
    {
         $data['active'] = 'admin_sample_put'; 
         $this->load->view('admin/sample/sample_put_new', $data);
    }

    public function sample_pick_new()
    {
        $UserID = $this->session->userdata('id');
        // print_r($pr);
        // die();
            // $data['paint_bin']       = $this->master_model->paint_bin();
            // $data['total_paint_bin']       = $this->master_model->total_paint_bin();
        $data['active'] = 'admin_sample_pick'; 
         $this->load->view('admin/sample/sample_pick_new', $data);
    }

    public function cprtm($sprt, $id)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_coprtment($sprt, $id);
        if ($cek != null) {
            $resp = [
                //'message' => 'paint exist on ' . $cek->code,
                'result'  => $cek,
                'status'  => false,
            ];

            echo json_encode($cek);
            return;
        }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }

     public function item_code1($itm_code)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        $cek = $this->master_model->cek_code_group1($itm_code);
         $id_cek = $cek[0]->id_unit;
        $cek1 = $this->master_model->cek_code_group2($id_cek);

        $cprtm1 = $this->master_model->cek_coprtment($itm_code, $id_cek);
        if ($cek != null) {
            $resp = [
                'message' => $id_cek,
                'result'  => $cek1,
                'result2'  => $cprtm1,
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
        }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }

    // find location for put paint
    public function get_location_put_sparepart()
    {   
        header('Content-Type: application/json');
        $unit        = $this->MasterUnit->where('id', 4)->get();
        $in_weight   = $this->input->post('kg');
        $id_capacity = $this->input->post('cp');
        $in_code     = $this->input->post('en_no');
        $item_code   = $this->input->post('item_color_code');
        $item_code_c   = $this->input->post('item_code');
        //$in_weight   = 5;
        //
         $cek = $this->master_model->cek_pr1($in_code, 'ts_item');
        if($cek == 1){
            echo json_encode([
                'success' => false,
                'msg'     => 'MB Exsis',
            ]);
            die;
        }
        //cari lokasi ms_item yg kosong
        $sqlr = "SELECT mi.* from ms_item as mi
                WHERE mi.code = '$item_code_c'
                ";

        $unitmsItem = $this->db->query($sqlr)->row();

        //cari lokasi bin yg kosong
        $sql = "SELECT mib.* from ms_unit_bin as mib
                WHERE mib.id_current_item = 0 and mib.id_bin_group = $item_code
                and mib.id_unit =4 AND mib.id_capacity = $id_capacity
                order by mib.code DESC limit 1";
 // echo json_encode([
 //                'success' => false,
 //                'msg'     => $sql,
 //            ]);

 //                die;

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            echo json_encode([
                'success' => false,
                'msg'     => 'no more space in unit',
            ]);
            die;
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $id_unit_Bin = $unitBin->id;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        //$code_unit_Bin1 = $unitBin->code;
        $kata="Please store item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth ;

            // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
            // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

            // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

            // $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        
         echo json_encode([
                'success' => true,
                'msg'     => $kata,
                'ms'      => $unitmsItem,
                //'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
            ]);

    }

    //insert put paint
    public function insert_put_sparepart()
    {
        // $this->load->library('form_validation');
        // $this->form_validation->set_rules('min_text_field', 'Text Field Two', 'required|min_length[8]');

        // if ($this->form_validation->run() == FALSE)
        // {
        //     $this->load->view('validate_form');
        // }
        // else
        // {
        //     // load success template...
        //     echo "It's all Good!";
        // }

        date_default_timezone_set('Asia/Jakarta');
        $date_now    = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1    = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_qty   = $this->input->post('kg_');
        $section     = $this->input->post('section');
        $submit      = $this->input->post('submit');
        $compartment = $this->input->post('compartment');
        //$unit        = $this->MasterUnit->where('id', 2)->get();
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $id_ms_item = $this->input->post('id_item');

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');
       //  if ($cek != null) {
       //      echo $cek;
       //      die;
       //  }

        // negecek item
        // $item = $this->MasterItem
        //     ->where('code', $item_code)
        //     ->where('id_category', '2')
        //     ->get();
        
        // if ($cek == null) {
        //     $id_item = $this->MasterItem->getLastId();
        // } else {
        //     $id_item = $item->id;
        // }
        $id_ts_item = $this->TransaksiItem->getLastId();

         $data_item = [
            'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_ms_item,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => 0,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => $in_qty,
            'out_qty'     => 0,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code1,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => 0,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => $in_qty,
            'status'      => 'PUT',
            'out_kg'      => 0,
            'out_qty'     => 0,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        //echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
        //print_r([$cek,$in_code1,$in_code, $data_item, $data_log, $_POST]);
        
        //die;
        $this->db->trans_start();
        if ($cek == null) {
            // insert ke ts_item
            $this->TransaksiItem->insert($data_item);
            // insert ke ts_item_log
             $this->MasterItemLog->insert($data_log);

             $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                'id_current_item' => $id_ts_item,
        ]);
        } else {
            //update time stamp master
            //$this->MasterItem->updated_at($id_item);
            echo "failed";
            redirect('admin_home/sparepart_put_new');
        }    
        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
     
        if ($submit == 'save') {
            // redirect
            redirect('admin_home/index/8.php');
            
        }

        if ($submit == 'save_and_put') {
            // redirect
            redirect('admin_home/sparepart_put_new');
        }
        //echo "successful";


    }



    //////find paint

    public function find_sparepart()
    {
        header('Content-Type: application/json');
        // $in_weight = $this->input->post('exp_kg');
         $id_bin_group = $this->input->post('id_bin_group');
        // if($in_weight == ''){
        //     $in_weight =0;
        // }
        $code      = strtoupper(trim($this->input->post('item_color_code')));
        // $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE (ti.in_kg-ti.out_kg+ti.dif_kg)>='" . $in_weight . "' AND upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =4 ORDER BY ti.store_date ASC")->row();
        $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE mub.id_bin_group='" . $id_bin_group . "' AND upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =4 ORDER BY ti.store_date ASC")->row();
        // echo json_encode([
        //     'msg'     => 'ok',
        //     'tsItem'  => $data_bin,
        //     'weight'  => $in_weight,
        //     'code'  => $code,
        // ]);
        // die();
        if ($data_bin == null) { //not found try to search next biggest available.
            $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE  upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =4 ORDER BY (ti.in_kg-ti.out_kg+ti.dif_kg) DESC, ti.store_date ASC")->row();
        }

        if ($data_bin == null) {
            $data['msg'] = "Item not found";
                echo json_encode([ 
                'msg' => "Item not found",
                'content' => $this->load->view('admin/get_item_not_avail_html', $data, true),
            ]);
            return;
            die;
        }

        $exp_kg = $data_bin->avail_kg;
        $item_code = $data_bin->code_item;
        $in_code = $data_bin->in_code;
        $ip = $data_bin->ip;
        $port = $data_bin->port;
        $unit_bin_shelf = $data_bin->shelf;
        $unit_bin_compartment = $data_bin->compartment;
        $static_depth         = $data_bin->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $data_bin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        $kata="Please take item on shelf : " .$unit_bin_shelf  . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth;

        // data ketemu
                    // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
                    // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';
        
                  //$client = new GuzzleHttp\Client(['base_uri' => $base_url]);

                //$resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $data_bin,
            'msg' => $kata,
        ];
        echo json_encode([
            'success'       => true,
            'data' => $data,
            'msg' => $kata,
            'tsItem'  => $data_bin,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }



    //save pick sparepart
    public function insert_pick_sparepart()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id_bin_group', 'Text Field Two', 'required|min_length[8]');

        if ($this->form_validation->run() == FALSE)
        {
            //$this->load->view('validate_form');
           $this->load->view('admin/admin_spareparts_pik_md');
        }
        else
        {
            // load success template...
            echo "It's all Good!";
        }
        die();
        date_default_timezone_set('Asia/Jakarta');
        $date_now     = date('Y-m-d h:i:s');           
        $user_id      = $this->session->userdata('id');
        $pr_no        = strtoupper(trim($this->input->post('pr_no')));
        $item_code    = strtoupper(trim($this->input->post('item_code')));
        $exp_kg       = $this->input->post('exp_kg');
        $location     = $this->input->post('location');
        $avail_weight = $this->input->post('avail_weight');
        $out_weight   = $this->input->post('out_weight');
        $last_out_kg  = $this->input->post('last_out_kg');
        $last_dif_kg  = $this->input->post('last_dif_kg');
        $last_out_qty = $this->input->post('last_out_qty');
        $id_item      = $this->input->post('id_item');
        //$id_ts_item   = $this->input->post('id_ts_item');
        $id_bin       = $this->input->post('id_bin');
        $in_code1     = $this->input->post('item_color_code');
        $in_code      = $this->MasterItem->clean_in_code($in_code1);

        $id_unit_Bin = $this->input->post('id_unit_bin');
        $section     = $this->input->post('id_bin_group');
        $out_qty     = $this->input->post('qty-avail');
        $code_ms_item     = $this->input->post('item-code-create');

        $id_ms_item1 = $this->master_model->select_in('ms_item','id','where code="'.$code_ms_item.'"');
        $id_ms_item2 = $id_ms_item1[0]->id;

        $id_ts_item = $this->TransaksiItem->getLastId();

         $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');

          // echo "<pre>";
          //   print_r($cek);
          // die();
          if($cek == 1){
            //echo "Failed";
            $this->session->set_flashdata('message', '<div class="alert alert-success">Failed</div>');
            redirect('admin_home/sparepart_pick_new/md');
          }
        // $en_code   = $this->input->post('en_code');
        $note   = $this->input->post('note');
        $submit = $this->input->post('submit');
        //echo $last_out_kg." + ".$out_weight;die();
        $data_ts_item = [
            'id_user'       => $user_id,
            'note'          => $note,
            'out_kg'        => $last_out_kg + $out_weight,
            'dif_kg'         => $last_dif_kg + $out_weight - $avail_weight,
            'out_qty'        => $last_out_qty + 1,
            'is_active'     => 0,
            'last_activity' => date("Y/m/d"),
        ];

        $data_item = [
            'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item2,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => 0,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => 0,
            'out_qty'     => $out_qty,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $user_id,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code1,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item2,
            'id_unit_bin' => $id_bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => 0,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => 0,
            'status'      => 'PICK',
            'out_kg'      => 0,
            'out_qty'     => $out_qty,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $user_id,
            'note'        => $note,
        ];

       echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
            print_r([$in_code1,$in_code, $data_item, $data_log, $_POST]);
        
        //die;

        //echo "<pre>";
        // print_r($data_ts_item);
        // print_r($data_log);
            // print_r([$_POST, $id_ms_item2]);
            // // print_r($this->db->queries);
            die;

        $this->db->trans_start();
        //update ms_item
        // $this->MasterItem->updated_at($id_item);
        // update ts_item
        //$this->TransaksiItem->where('id', $id_ts_item)->update($data_ts_item);

        //update ke ms_unit
        //$this->MasterUnit->where('id', $unit->id)->update($data_ms_unit);

        //update ke ms_unit_bin
        // if ($pcs == $avail_qty || $bin_empty == 'on') {
        
        //}

            // $this->MasterItem->where('id', $id_item)->update(['updated_at', $date_now]);
        // insert log
         $this->TransaksiItem->insert($data_item);
        $this->MasterItemLog->insert($data_log);
        $this->MasterUnitBin->where('id', $id_bin)->update([
            'id_current_item' => 0,
        ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "data gagal";
        }

        if ($submit == 'save') {
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
            // redirect
            redirect('admin_home/sparepart_pick_new/md');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }

    ////////////////////////////////////////////////////////////////////////////
    public function rubber_put_new()
    {

        $UserID = $this->session->userdata('id');
        // print_r($UserID);
        // die();

        $data['small_bin']   = $this->master_model->small_bin();
        $data['normal_bin']  = $this->master_model->normal_bin();
        $data['paint_bin']         = $this->master_model->paint_bin();
        $data['total_small_bin']   = $this->master_model->total_small_bin();
        $data['total_normal_bin']  = $this->master_model->total_normal_bin();
        $data['total_paint_bin']   = $this->master_model->total_paint_bin();
        $data['mesin']   = $this->master_model->mesin();
        $data['active'] = 'admin_put';
        // print_r($data['mesin']);
        // die();
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/rubber/rubber_put_new', $data);
    }

     ////////////////////////////////////////////////////////////////////////////

    public function rubber_pick_new()
    {
        $this->Admin_user_model->auth()->hasUpdate($menu_id = 5)->redirect('/admin_by_category/list');
        $UserID = $this->session->userdata('id');
        @$PR_ID = $this->uri->segment(3);
        if ($PR_ID != '') {
            $sql = "SELECT (ti.in_qty-ti.out_qty+ti.dif_qty) as exp_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as exp_kg, (ti.in_qty-ti.out_qty+ti.dif_qty) as avail_qty, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg, mub.id_unit, mub.code as codeb, mub.id as id_unit_bin, mi.code, mi.name, mi.unit_weight, mi.id as id_item, ti.is_dasaran 
        FROM ts_item AS ti 
        LEFT join ms_unit_bin as mub ON mub.id=ti.id_unit_bin
         LEFT join ms_item as mi ON mi.id = ti.id_item
         WHERE ti.in_code='" . $PR_ID . "' ";
            $qry               = $this->db->query($sql);
            $row               = $qry->result_array();
            $data['data_pick'] = $row;
            // echo "<pre>";
            // print_r($row);
            // die;
        }
        $data['last_mt'] = $this->master_model->mst_last_np('ts_item_log','NP');

        $data['mesin']   = $this->master_model->mesin();
        // print_r($data['data_pick']);
        // die();

        // take from function in application/controllers/authcontroller

        $data['active'] = 'admin_pick';
        // $data['CurrentImageList'] = $this->admin_about_model->CurrentImageList();
        // $data['config_module']    = $this->admin_about_model->config_module($MENU_ID);
        // $data['DataEdit'] = $this->admin_about_model->DataEdit();

        $this->load->view('admin/rubber/rubber_pick_new', $data);
    }


    //insert put slider
    public function insert_put_rubber()
    {
        date_default_timezone_set('Asia/Jakarta');
        $date_now = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $create_date = $this->input->post('create_date');
        $submit      = $this->input->post('submit');
        $in_code1     = strtoupper(trim($this->input->post('pr_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_code')));
        $item_name   = $this->input->post('item_name');
        $unit_weight = $this->input->post('unit_weight');
        $exp_qty     = $this->input->post('exp_qty');
        $exp_kg      = $this->input->post('exp_kg');
        $in_qty      = $this->input->post('pcs');
        $in_kg       = $this->input->post('kg');
        $pos_bal     = $this->input->post('pos_bal');
        $id_unit_bin = $this->input->post('id_unit_bin');
        $dasaran     = $this->input->post('tipe');
        if($dasaran == 'on'){
            // $is_dasaran = 1;
            $is_dasaran = 0;
        } else {
            $is_dasaran = 0;
        }

        $mesin     = $this->input->post('mesin');
        $unit        = $this->MasterUnit->where('id', $mesin)->get();
            // $unit        = $this->MasterUnit->where('id', 1)->get();
         $category    = 3;
        // $UserName    = '1';
        // $note        = "test";
        // $create_date = "2020-05-08";
        // $submit      = "save_and_put";
        // $in_code     = "PR02271710";
        // $item_code   = "1100750";
        // $item_name   = "05 CN DA8L ET PARTS";
        // $unit_weight = "0.005039";
        // $exp_qty     = "3832";
        // $exp_kg      = "19.309448";
        // $in_qty      = "3832";
        // $in_kg       = "19.309448";
        
        //echo $last_position;
        
        $item = $this->MasterItem
            ->where('code', $item_code)
            ->where('name', $item_name)
            ->where('id_category', $category)
            ->get();
   
        if ($item == null) {
            $id_item = $this->MasterItem->getLastId();
        } else {
            $id_item = $item->id;
        }

        $data_item = [
            'id'          => $id_item,
            'id_category' => 3,
            'code'        => $item_code,
            'name'        => $item_name,
            'unit_weight' => $unit_weight,
        ];
        $id_ts_item = $this->TransaksiItem->getLastId();
        $data_log   = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => $unit_weight,
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            'in_kg'       => $in_kg,
            'in_qty'      => $in_qty,
            'bal_qty'     => $in_qty,
            'bal_kg'      => $in_kg,
            'id_user'     => $UserName,
            'status'      => 'PUT',
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            // 'is_active' => $item_name,
            'note'        => $note,
            'is_dasaran'  => $is_dasaran,
        ];

        $data_ts_item = [
            // 'id_category'   => 1,
            'id'          => $id_ts_item,
            'in_code'     => $in_code,
            'is_active'   => 1,
            // 'out_code'  => $item_code,
            'id_unit_bin' => $id_unit_bin,
            'id_item'     => $id_item,
            'store_date'  => $create_date,
            'unit_weight' => $unit_weight,
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            'in_kg'       => $in_kg,
            'in_qty'      => $in_qty,
            //'updated_at'  => $date_now,
            // 'out_kg'        => $item_name,
            // 'out_qty'       => $item_name,
            // 'dif_kg'        => $item_name,
            // 'dif_qty'       => $item_name,
            'id_user'     => $UserName,
            'note'        => $note,
            'is_dasaran'  => $is_dasaran,
        ];

        echo "<pre>";
        //print_r($data_ts_item);
         //print_r($data_log);
         //print_r($data_item);
        print_r([$item, $data_item, $data_ts_item, $data_log, $_POST]);
        //echo "<pre>";
        // echo $pos_bal;
        // echo "<br>";
        //echo $id_nilai = $unit->balance_weight1 + $in_kg;
        // echo "<br>";
        // echo $id_nilai2 = $unit->balance_weight2 + $in_kg;
        die;

        $this->db->trans_start();
        if ($item == null) {
            // insert ke ts_item
            $this->MasterItem->insert($data_item);
        } else {
            $this->MasterItem->updated_at($id_item);
            //$this->MasterItem->where('id', $id_item)->update('updated_at',$date_now);
            // $where = array('id' => $id_item);
            // $data['user'] = $this->master_model->edit_data($where,'updated_at')->result();
        }

        // insert ke ts_item
        $this->TransaksiItem->insert($data_ts_item);

        // insert ke ts_item_log
        $this->MasterItemLog->insert($data_log);

        if ($pos_bal == 1) {
            $this->MasterUnit->where('id', $unit->id)->update([
                'balance_weight1' => $unit->balance_weight1 + $in_kg,
            ]);
        } else {
            $this->MasterUnit->where('id', $unit->id)->update([
                'balance_weight2' => $unit->balance_weight2 + $in_kg,
            ]);
        }

        $this->MasterUnitBin->where('id', $id_unit_bin)->update([
            'id_current_item' => $id_ts_item,
        ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
       
        if ($submit == 'save') {
            $this->session->set_flashdata('messages', 'Add data PUT Rubber Slider');
            // redirect
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_put') {
            // redirect
            $this->session->set_flashdata('messages', 'Add data PUT Rubber Slider');
            redirect('admin_home/put_new');
        }
        //echo "successful";
    }

    //insert pick slider
    public function insert_pick_rubber()
    {
        date_default_timezone_set('Asia/Jakarta');
        $date_now = date('Y-m-d h:i:s');
        $submit         = $this->input->post('submit');
        $user_id        = $this->session->userdata('id');
        $note           = $this->input->post('note');
        $bin_empty      = $this->input->post('publish');
        $in_code1        = strtoupper(trim($this->input->post('pr_no')));
        $in_code        = $this->MasterItem->clean_in_code($in_code1);
        $item_code      = strtoupper(trim($this->input->post('item_code')));
        $item_name      = $this->input->post('item_name');
        $unit_weight    = $this->input->post('unit_weight');
        $exp_qty        = $this->input->post('exp_qty');
        $exp_kg         = $this->input->post('exp_kg');
        $avail_qty      = $this->input->post('avail_qty');
        $avail_kg       = $this->input->post('avail_kg');
        $pcs            = $this->input->post('pcs');
        $kg             = $this->input->post('kg');
        $id_item        = $this->input->post('item_id');
        $ms_unit_bin_id = $this->input->post('ms_unit_bin_id');
        $category       = 3;
        $dasaran     = $this->input->post('tipe');
        if($dasaran == 'on'){
            //$is_dasaran = 1;
            $is_dasaran = 0;
        } else {
            $is_dasaran = 0;
        }

             $mesin  = $this->input->post('mesin');
             $unit   = $this->MasterUnit->where('id', $mesin)->get();
            //$unit    = $this->MasterUnit->where('id', 1)->get();
        $unitBin = $this->MasterUnitBin->where('id', $ms_unit_bin_id)->get();
        $tsItem  = $this->TransaksiItem->where('id', $unitBin->id_current_item)->get();
        $dif_qty = 0;
        $dif_kg  = 0;
        $out_kg  = $tsItem->out_kg + $kg;
        $out_qty = $tsItem->out_qty + $pcs;

        // maka habis
        if ($pcs == $avail_qty) {
            $data_ts_item = [
                'id_user'       => $user_id,
                'note'          => $note,
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'is_active'     => 0,
                'last_activity' => date("Y/m/d"),
            ];
        } else {
            $data_ts_item = [
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'is_active'     => 1,
                'last_activity' => date("Y/m/d"),
                'id_user'       => $user_id,
                'note'          => $note,
            ];
        }

        //' ambil semua
        if ($bin_empty == 'on') {
            $dif_qty = $tsItem->dif_qty + ($pcs - $avail_qty);
            $dif_kg  = $tsItem->dif_kg + ($kg - $avail_kg);

            $data_ts_item = [
                'out_kg'        => $out_kg,
                'out_qty'       => $out_qty,
                'dif_qty'       => $dif_qty,
                'dif_kg'        => $dif_kg,
                'is_active'     => 0,
                'last_activity' => date("Y/m/d"),
                'id_user'       => $user_id,
                //'updated_at'    => $date_now,
                'note'          => $note,
            ];
        }

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $tsItem->id,
            // 'in_code'       => $in_code,
            'out_code'    => $in_code,
            'id_unit_bin' => $ms_unit_bin_id,
            'id_item'     => $id_item,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $unit_weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => $exp_kg,
            'exp_qty'     => $exp_qty,
            // 'in_kg'    => $in_kg,
            // 'in_qty'   => $in_qty,
            'status'      => 'PICK',
            'out_kg'      => $kg,
            'out_qty'     => $pcs,
            'bal_qty'     => $avail_qty - $pcs,
            'bal_kg'      => $avail_kg - $kg,
            'dif_kg'      => $dif_kg,
            'dif_qty'     => $dif_qty,
            'id_user'     => $user_id,
            'note'        => $note,
            'is_dasaran'  => $is_dasaran,
        ];

        if ($unitBin->shelf <= ($unit->shelf / 2)) {
            //  'kiri
            $data_ms_unit = [
                'balance_weight1' => $unit->balance_weight1 - $kg,
            ];
        } else {
            //  'kanan
            $data_ms_unit = [
                'balance_weight2' => $unit->balance_weight2 - $kg,
            ];
        }

        //echo "<pre>";
        // print_r($_POST);
        // print_r($data_ts_item);
        // print_r($tsItem);
        // print_r($data_log);
        // print_r($this->db->queries);
         //print_r([$id_item, $tsItem->id, $data_ts_item, $data_ms_unit, $data_log, $_POST]);
         //die;

        $this->db->trans_start();
        //update master item
        $this->MasterItem->updated_at($id_item);
        // update ts_item
        $this->TransaksiItem->where('id', $tsItem->id)->update($data_ts_item);

        //update ke ms_unit
        $this->MasterUnit->where('id', $unit->id)->update($data_ms_unit);

        //update ke ms_unit_bin
        if ($pcs == $avail_qty || $bin_empty == 'on') {
            $this->MasterUnitBin->where('id', $ms_unit_bin_id)->update([
                'id_current_item' => 0,
            ]);
        }

        

        // insert log
        $this->MasterItemLog->insert($data_log);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "data gagal";
        }

        if ($submit == 'save') {
            $this->session->set_flashdata('messages', 'Add data Pick Rubber Slider');
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
             $this->session->set_flashdata('messages', 'Add data Pick Rubber Slider');
            // redirect
            redirect('admin_home/rubber_pick_new');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }

    public function en_no_put_new($en_no)
    {
        $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        // $cek = $this->master_model->cek_paint_exist($en_no);
        $cek = $this->master_model->cek_sparepart_exist($en_no);
        if ($cek != null) {
            $resp = [
                'message' => 'paint exist on ' . $cek->code,
                'result'  => $cek,
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
        }
        else {
            $resp = [
                'message' => 'paint exist on ' . $cek->code,
                'result'  => $cek,
                'en_no'   => $en_no,
                'status'  => true,
            ];

            echo json_encode($resp);
            return;
        }

        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }

    // find location for put paint
    public function get_location_pick_sparepart()
    {   
        header('Content-Type: application/json');
        $unit        = $this->MasterUnit->where('id', 2)->get();
        $in_weight   = $this->input->post('kg');
        $in_code     = $this->input->post('en_no');
        $item_code   = $this->input->post('item_color_code');
        //$in_weight   = 5;

        //cari lokasi bin yg kosong
        $sql = "SELECT mib.* from ms_unit_bin as mib
                inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                WHERE mib.id_current_item = 0
                and mib.id_unit =4 AND muc.capacity >=$in_weight
                order by mib.code DESC limit 1";

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            echo json_encode([
                'success' => false,
                'msg'     => 'no more space in unit',
            ]);
            die;
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $id_unit_Bin = $unitBin->id;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        //$code_unit_Bin1 = $unitBin->code;
        $kata="Please store item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth ;

        // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

        // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        // $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        
         echo json_encode([
                'success' => true,
                'msg'     => $kata,
                //'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
            ]);

    }


    public function molding_no_put($en_no)
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;
        header('Content-Type: application/json');

        // $cek = $this->master_model->cek_paint_exist($en_no);
         $cek = $this->master_model->cek_put_mo($en_no);
        if ($cek != null) {
            $resp = [
                //'message' => 'paint exist on ' . $cek->name,
                'result'  => $cek,
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
        }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }


    // find location for put paint
    public function get_location_put_molding()
    {   
        header('Content-Type: application/json');
        $unit        = $this->MasterUnit->where('id', 6)->get();
        $self        = $this->input->post('self');
        $in_weight   = $this->input->post('kg');
        $in_code     = $this->input->post('en_no');
        $nod         = $this->input->post('nod');
        $item_code   = $this->input->post('item_color_code');
        //$in_weight   = 5;
            $id_cpa = $this->master_model->cek_put_mo1($nod, $in_code);            
            $id_cp = $id_cpa->id_capacity;
        //cari lokasi bin yg kosong
        $sql = "SELECT mib.* from ms_unit_bin as mib
                WHERE mib.id_current_item = 0
                and mib.id_unit =6 AND mib.shelf = '$self' AND mib.id_capacity ='$id_cp'
                order by mib.code DESC limit 1";

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            echo json_encode([
                'success' => false,
                'msg'     => 'no more space in unit',
                'id_cp'   => $id_cp,
            ]);
            die;
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $id_unit_Bin = $unitBin->id;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        //$code_unit_Bin1 = $unitBin->code;
        $kata="Please store item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth ;

            // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
            // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

            // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

            // $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        
        //mencari ms_item id
        $sqlr = "SELECT mi.* from ms_item as mi
                WHERE mi.code = '$in_code' and mi.name = '$nod'
                ";

        $unitmsItem = $this->db->query($sqlr)->row();

         echo json_encode([
                'success' => true,
                'msg'     => $kata,
                'ms'      => $unitmsItem,                
                //'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
            ]);

    }


    //insert put paint
    public function insert_put_molding()
    {
        // $this->load->library('form_validation');
        // $this->form_validation->set_rules('min_text_field', 'Text Field Two', 'required|min_length[8]');

        // if ($this->form_validation->run() == FALSE)
        // {
        //     $this->load->view('validate_form');
        // }
        // else
        // {
        //     // load success template...
        //     echo "It's all Good!";
        // }

        date_default_timezone_set('Asia/Jakarta');
        $date_now    = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1    = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_qty   = $this->input->post('kg_');
        $section     = $this->input->post('section');
        $submit      = $this->input->post('submit');
        $compartment = $this->input->post('compartment');
        //$unit        = $this->MasterUnit->where('id', 2)->get();
        //$weight = $this->input->post('weight');
        $weight = 0;
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $quantity = $this->input->post('quantity');
        $id_ms_item = $this->input->post('id_item');
        $number = $this->input->post('number');
        $incode = $in_code1.'-'.$number;

        $id_ts_item_old = $this->input->post('id_current_item');
        $location = $this->input->post('location');
        $in_qty_old = $this->input->post('in_qty');
        $in_qty_item = $this->input->post('in_qty_item');
        


        //@$to_in_up         = $in_qty_old + $in_qty_item;

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($incode, 'ts_item');
       
       $cek1 = $this->master_model->select_in('ms_unit_bin as mib','mib.*',"WHERE mib.id_current_item = 0
                and mib.id_unit =6 AND mib.code = '$location' order by mib.code DESC limit 1");

       //echo $cek1[0]->id;
       //die;
        if ($cek1 == null) {
            $to_in      = $in_qty_old + $quantity;
             @$to_in_up         = $quantity + $in_qty_item;
                  
        } else {
            $qts = 0;
            $to_in      = $qts + $quantity; 

             @$to_in_up         = $in_qty_old + $in_qty_item;
        }

        // negecek item
        // $item = $this->MasterItem
        //     ->where('code', $item_code)
        //     ->where('id_category', '2')
        //     ->get();
        
        // if ($cek == null) {
        //     $id_item = $this->MasterItem->getLastId();
        // } else {
        //     $id_item = $item->id;
        // }
        $id_ts_item = $this->TransaksiItem->getLastId();

         $data_item = [
           // 'id'          => $id_ts_item,
            'in_code'     => $incode,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_ms_item,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => $weight,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => $quantity,
            'out_qty'     => 0,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $incode,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => $quantity,
            'bal_qty'     => $to_in,
            'bal_kg'      => 0,
            'status'      => 'PUT',
            'out_kg'      => 0,
            'out_qty'     => 0,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log_up = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item_old,
            'in_code'     => $incode,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => $quantity,
            'bal_qty'     => $to_in,
            'bal_kg'      => 0,
            'status'      => 'PUT',
            'out_kg'      => 0,
            'out_qty'     => 0,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        //echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
         //print_r($data_ts_item);
      //print_r([$cek, $cek1,$to_in_up,$to_in,$incode, $data_item, $data_log, $data_log_up, $_POST]);
        
        //die;
        $this->db->trans_start();
        if($cek1 == null){
            //update ts_item
            $this->TransaksiItem->where('id', $id_ts_item_old)->update([
                'last_activity' => date("Y-m-d"),
                'in_qty'        => $to_in_up,
                'note'          => $note,
                //'updated_at' => date("Y-m-d H:i:s"),
                ]);
            // insert ke ts_item_log
             $this->MasterItemLog->insert($data_log_up);
        } else 
         {
            // insert ke ts_item
            $this->TransaksiItem->insert($data_item);
            // insert ke ts_item_log
             $this->MasterItemLog->insert($data_log);

             $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                'id_current_item' => $id_ts_item,
            ]);
        } 

                // else {
                //     //update time stamp master
                //     //$this->MasterItem->updated_at($id_item);
                //     echo "failed";
                //     redirect('admin_home/molding_put_new');
                // }    
        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('messagef', 'Add data Die Cast Molding succes');
            echo "failed";
        }
        
     
        if ($submit == 'save') {
            // redirect
            $this->session->set_flashdata('messages', 'Add data Molding succes');
            redirect('admin_home/index/8.php');
            
        }

        if ($submit == 'save_and_put_dm') {
            // redirect
            $this->session->set_flashdata('messages', 'Add data Die Cast Molding succes');
            redirect('admin_home/molding_put_new/dm');
        } elseif ($submit == 'save_and_put_dd')
        {
            $this->session->set_flashdata('messages', 'Add data Die Cast Set Molding succes');
             redirect('admin_home/molding_put_new/dd');
        } elseif ($submit == 'save_and_put_rm')
        {
            $this->session->set_flashdata('messages', 'Add data Rubber Molding succes');
             redirect('admin_home/molding_put_new/rm');
        } elseif ($submit == 'save_and_put_as')
        {
            $this->session->set_flashdata('messages', 'Add data Assembling SHO Molding succes');
             redirect('admin_home/molding_put_new/as');
        }
        //echo "successful";


    }


     //////find paint

    public function find_sparepart_pick()
    {
        header('Content-Type: application/json');
        // $in_weight = $this->input->post('exp_kg');
         $id_bin_group = $this->input->post('id_bin_group');
        // if($in_weight == ''){
        //     $in_weight =0;
        // }
        $code      = strtoupper(trim($this->input->post('item_color_code')));
        // $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE (ti.in_kg-ti.out_kg+ti.dif_kg)>='" . $in_weight . "' AND upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =4 ORDER BY ti.store_date ASC")->row();
        $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE mub.id_bin_group='" . $id_bin_group . "' AND upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =4 ORDER BY ti.store_date ASC")->row();
        // echo json_encode([
        //     'msg'     => 'ok',
        //     'tsItem'  => $data_bin,
        //     'weight'  => $in_weight,
        //     'code'  => $code,
        // ]);
        // die();
        if ($data_bin == null) { //not found try to search next biggest available.
            $data_bin  = $this->db->query("SELECT mu.ip, mu.port, mu.static_depth, mub.id as idb, mi.code as code_item, mub.code, mub.shelf, mub.compartment, mub.depth, ti.id as id_ts_item, ti.out_kg, ti.id_item as id_item, (ti.in_kg-ti.out_kg+ti.dif_kg) as avail_kg,  ti.in_code FROM ts_item as ti left join ms_unit_bin as mub on mub.id = ti.id_unit_bin left join ms_item mi on mi.id = ti.id_item LEFT join ms_unit as mu ON mu.id = mub.id_unit WHERE  upper(trim(mi.code)) = '" . $code . "' AND ti.is_active = 1 AND mub.id_unit =4 ORDER BY (ti.in_kg-ti.out_kg+ti.dif_kg) DESC, ti.store_date ASC")->row();
        }

        if ($data_bin == null) {
            $data['msg'] = "Item not found";
                echo json_encode([ 
                'msg' => "Item not found",
                'content' => $this->load->view('admin/get_item_not_avail_html', $data, true),
            ]);
            return;
            die;
        }

        $exp_kg = $data_bin->avail_kg;
        $item_code = $data_bin->code_item;
        $in_code = $data_bin->in_code;
        $ip = $data_bin->ip;
        $port = $data_bin->port;
        $unit_bin_shelf = $data_bin->shelf;
        $unit_bin_compartment = $data_bin->compartment;
        $static_depth         = $data_bin->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $data_bin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        $kata="Please take item on shelf : " .$unit_bin_shelf  . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth;

        // data ketemu
                    // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
                    // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $exp_kg. '';
        
                  //$client = new GuzzleHttp\Client(['base_uri' => $base_url]);

                //$resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;

        $data = [
            'tsItem' => $data_bin,
            'msg' => $kata,
        ];
        echo json_encode([
            'success'       => true,
            'data' => $data,
            'msg' => $kata,
            'tsItem'  => $data_bin,
            'sql'     => $this->db->queries,
            'content' => $this->load->view('admin/get_item_avail_html', $data, true),
        ]);

    }


    public function insert_pick_sparepart_dp()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('id_bin_group', 'Text Field Two', 'required|min_length[8]');

        if ($this->form_validation->run() == FALSE)
        {
            //$this->load->view('validate_form');
           $this->load->view('admin/admin_spareparts_pik_md');
        }
        else
        {
            // load success template...
            echo "It's all Good!";
        }
        //die();
        date_default_timezone_set('Asia/Jakarta');
        $date_now     = date('Y-m-d h:i:s');           
        $user_id      = $this->session->userdata('id');
        $pr_no        = strtoupper(trim($this->input->post('pr_no')));
        $item_code    = strtoupper(trim($this->input->post('item_code')));
        $exp_kg       = $this->input->post('exp_kg');
        $location     = $this->input->post('location');
        $avail_weight = $this->input->post('avail_weight');
        $out_weight   = $this->input->post('out_weight');
        $last_out_kg  = $this->input->post('last_out_kg');
        $last_dif_kg  = $this->input->post('last_dif_kg');
        $last_out_qty = $this->input->post('last_out_qty');
        $id_item      = $this->input->post('id_item');
        //$id_ts_item   = $this->input->post('id_ts_item');
        $id_bin       = $this->input->post('id_bin');
        $in_code1     = $this->input->post('dp_no');
        $in_code      = $this->MasterItem->clean_in_code($in_code1);

        $id_unit_Bin = $this->input->post('id_unit_bin');
        $section     = $this->input->post('id_bin_group');
        $out_qty     = $this->input->post('kg_');
        $code_ms_item     = $this->input->post('item-code-create');

        $id_ms_item1 = $this->master_model->select_in('ms_item','id','where code="'.$code_ms_item.'"');
        $id_ms_item2 = $id_ms_item1[0]->id;

        $id_ts_item = $this->TransaksiItem->getLastId();

         $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');

          // echo "<pre>";
          //   print_r($cek);
          // die();
          if($cek == 1){
            //echo "Failed";
            $this->session->set_flashdata('message', '<div class="alert alert-success">Failed</div>');
            redirect('admin_home/sparepart_pick_new/md');
          }
        // $en_code   = $this->input->post('en_code');
        $note   = $this->input->post('note');
        $submit = $this->input->post('submit');
        //echo $last_out_kg." + ".$out_weight;die();
        $data_ts_item = [
            'id_user'       => $user_id,
            'note'          => $note,
            'out_kg'        => $last_out_kg + $out_weight,
            'dif_kg'         => $last_dif_kg + $out_weight - $avail_weight,
            'out_qty'        => $last_out_qty + 1,
            'is_active'     => 0,
            'last_activity' => date("Y/m/d"),
        ];

        $data_item = [
            'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item2,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => 0,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => 0,
            'out_qty'     => $out_qty,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $user_id,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code1,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item2,
            'id_unit_bin' => $id_bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => 0,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => 0,
            'status'      => 'PICK',
            'out_kg'      => 0,
            'out_qty'     => $out_qty,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $user_id,
            'note'        => $note,
        ];

          // echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
           // print_r([$in_code1,$in_code, $data_item, $data_log, $_POST]);      
       
            //die;

        $this->db->trans_start();
        

            // $this->MasterItem->where('id', $id_item)->update(['updated_at', $date_now]);
        // insert log
          $this->TransaksiItem->insert($data_item);
          $this->MasterItemLog->insert($data_log);
          $this->MasterUnitBin->where('id', $id_bin)->update([
            'id_current_item' => 0,
          ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "data gagal";
        }

        if ($submit == 'save') {
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
            // redirect
            redirect('admin_home/sparepart_pick_new/disposal');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }


    //insert put paint
    public function insert_put_molding_dm()
    {
        // $this->load->library('form_validation');
        // $this->form_validation->set_rules('min_text_field', 'Text Field Two', 'required|min_length[8]');

        // if ($this->form_validation->run() == FALSE)
        // {
        //     $this->load->view('validate_form');
        // }
        // else
        // {
        //     // load success template...
        //     echo "It's all Good!";
        // }

        date_default_timezone_set('Asia/Jakarta');
        $date_now    = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1    = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_qty   = $this->input->post('quantity');
        $section     = $this->input->post('section');
        $submit      = $this->input->post('submit');
        $compartment = $this->input->post('compartment');
        //$unit        = $this->MasterUnit->where('id', 2)->get();
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $id_ms_item = $this->input->post('id_item');

        $weight = $this->input->post('weight');

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');
       //  if ($cek != null) {
       //      echo $cek;
       //      die;
       //  }

        // negecek item
        // $item = $this->MasterItem
        //     ->where('code', $item_code)
        //     ->where('id_category', '2')
        //     ->get();
        
        // if ($cek == null) {
        //     $id_item = $this->MasterItem->getLastId();
        // } else {
        //     $id_item = $item->id;
        // }
        $id_ts_item = $this->TransaksiItem->getLastId();

         $data_item = [
            'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_ms_item,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => $weight,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => $in_qty,
            'out_qty'     => 0,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code1,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => $in_qty,
            'status'      => 'PUT',
            'out_kg'      => 0,
            'out_qty'     => 0,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        //echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
        //print_r([$cek,$in_code1,$in_code, $data_item, $data_log, $_POST]);
        
        //die;
        $this->db->trans_start();
        if ($cek == null) {
            // insert ke ts_item
            $this->TransaksiItem->insert($data_item);
            // insert ke ts_item_log
             $this->MasterItemLog->insert($data_log);

             $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                'id_current_item' => $id_ts_item,
        ]);
        } else {
            //update time stamp master
            //$this->MasterItem->updated_at($id_item);
            //echo "failed";
            $this->session->set_flashdata('messagef', 'Failed');
            redirect('admin_home/molding_put_new/dm');
        }    
        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
     
        if ($submit == 'save') {
            $this->session->set_flashdata('messages', 'Success Add');
            // redirect
            redirect('admin_home/index/8.php');
            
        }

        if ($submit == 'save_and_put') {
            // redirect
            $this->session->set_flashdata('messages', 'Success Add');
            redirect('admin_home/molding_put_new/dm');
        }
        //echo "successful";
    }


    //insert put paint
    public function insert_put_molding_dd()
    {
              date_default_timezone_set('Asia/Jakarta');
        $date_now    = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1    = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_qty   = $this->input->post('quantity');
        $section     = $this->input->post('section');
        $submit      = $this->input->post('submit');
        $compartment = $this->input->post('compartment');
        //$unit        = $this->MasterUnit->where('id', 2)->get();
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $id_ms_item = $this->input->post('id_item');

        $weight = $this->input->post('weight');

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');
       //  if ($cek != null) {
       //      echo $cek;
       //      die;
       //  }

        // negecek item
        // $item = $this->MasterItem
        //     ->where('code', $item_code)
        //     ->where('id_category', '2')
        //     ->get();
        
        // if ($cek == null) {
        //     $id_item = $this->MasterItem->getLastId();
        // } else {
        //     $id_item = $item->id;
        // }
        $id_ts_item = $this->TransaksiItem->getLastId();

         $data_item = [
            'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_ms_item,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => $weight,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => $in_qty,
            'out_qty'     => 0,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code1,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => $in_qty,
            'status'      => 'PUT',
            'out_kg'      => 0,
            'out_qty'     => 0,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
        print_r([$cek,$in_code1,$in_code, $data_item, $data_log, $_POST]);
        
       die;
        $this->db->trans_start();
        if ($cek == null) {
            // insert ke ts_item
            $this->TransaksiItem->insert($data_item);
            // insert ke ts_item_log
             $this->MasterItemLog->insert($data_log);

             $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                'id_current_item' => $id_ts_item,
        ]);
        } else {
            //update time stamp master
            //$this->MasterItem->updated_at($id_item);
            //echo "failed";
            $this->session->set_flashdata('messagef', 'Failed');
            redirect('admin_home/molding_put_new/dm');
        }    
        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
     
        if ($submit == 'save') {
            $this->session->set_flashdata('messages', 'Success Add');
            // redirect
            redirect('admin_home/index/8.php');
            
        }

        if ($submit == 'save_and_put') {
            // redirect
            $this->session->set_flashdata('messages', 'Success Add');
            redirect('admin_home/molding_put_new/dm');
        }
        //echo "successful";


    }


     //insert put paint
    public function insert_put_molding_rm()
    {
              date_default_timezone_set('Asia/Jakarta');
        $date_now    = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1    = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_qty   = $this->input->post('quantity');
        $section     = $this->input->post('section');
        $submit      = $this->input->post('submit');
        $compartment = $this->input->post('compartment');
        //$unit        = $this->MasterUnit->where('id', 2)->get();
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $id_ms_item = $this->input->post('id_item');

        $weight = $this->input->post('weight');

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');
       //  if ($cek != null) {
       //      echo $cek;
       //      die;
       //  }

        // negecek item
        // $item = $this->MasterItem
        //     ->where('code', $item_code)
        //     ->where('id_category', '2')
        //     ->get();
        
        // if ($cek == null) {
        //     $id_item = $this->MasterItem->getLastId();
        // } else {
        //     $id_item = $item->id;
        // }
        $id_ts_item = $this->TransaksiItem->getLastId();

         $data_item = [
            'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_ms_item,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => $weight,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => $in_qty,
            'out_qty'     => 0,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code1,
            //'out_code'    => $pr_no,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => $in_qty,
            'status'      => 'PUT',
            'out_kg'      => 0,
            'out_qty'     => 0,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
        print_r([$cek,$in_code1,$in_code, $data_item, $data_log, $_POST]);
        
       die;
        $this->db->trans_start();
        if ($cek == null) {
            // insert ke ts_item
            $this->TransaksiItem->insert($data_item);
            // insert ke ts_item_log
             $this->MasterItemLog->insert($data_log);

             $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                'id_current_item' => $id_ts_item,
        ]);
        } else {
            //update time stamp master
            //$this->MasterItem->updated_at($id_item);
            //echo "failed";
            $this->session->set_flashdata('messagef', 'Failed');
            redirect('admin_home/molding_put_new/dm');
        }    
        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
     
        if ($submit == 'save') {
            $this->session->set_flashdata('messages', 'Success Add');
            // redirect
            redirect('admin_home/index/8.php');
            
        }

        if ($submit == 'save_and_put') {
            // redirect
            $this->session->set_flashdata('messages', 'Success Add');
            redirect('admin_home/molding_put_new/dm');
        }
        //echo "successful";


    }


    public function cek_pr()
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;
        $item = $this->input->post('item');
        $number = $this->input->post('number');
        $gb = $item.'-'.$number;
        header('Content-Type: application/json');
        // echo json_encode($gb);
        // return;
        //$cek = $this->master_model->cek_pr1($gb, 'ts_item');
        $cek = $this->master_model->select_in('ts_item as ti left join ms_unit_bin as mub ON ti.id_unit_bin=mub.id LEFT JOIN ( SELECT  til.bal_qty, til.in_code, til.id_item,til.id_unit_bin, til.id_ts_item,
                          til.store_date, til.in_qty,
                          til.out_qty, til.status,
                          sum(til.in_kg-til.out_kg+til.dif_kg) as avail_kg,
                          sum(til.in_qty-til.out_qty+til.dif_qty) as avail_qty
                          FROM ts_item_log as til
                          order by til.id asc 
                          ) as detail ON detail.id_ts_item=ti.id', 'detail.avail_qty, (ti.in_qty-ti.out_qty) as avail, ti.id_item, ti.id_item, ti.in_qty, mub.id as id_mub, mub.code, mub.id_current_item','WHERE ti.in_code="'.$gb.'" and (ti.in_qty-ti.out_qty) > 0 ORDER BY avail ASC');
             //$cek = $this->master_model->cek_put_mo($en_no);
            if ($cek != null) { 

                $resp = [ 
                 'id_mub'         => $cek[0]->id_mub, 
                'id_item'         => $cek[0]->id_item, 
                'in_qty'          => $cek[0]->in_qty, 
                'id_current_item' => $cek[0]->id_current_item, 
                'avail_qty'       => $cek[0]->avail_qty,
                'avail'           => $cek[0]->avail,           
                'code'            => $cek[0]->code,                
                'status'          => true,
                 ];              
                echo json_encode($resp);
                return;
                // echo json_encode($cek);
                // return;
            } else {               
                echo json_encode($cek);
                return;
            }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }


    public function cek_pr_pick()
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;
        $item = $this->input->post('item');
        $number = $this->input->post('number');
        $gb = $item.'-'.$number;
        header('Content-Type: application/json');
        // echo json_encode($gb);
        // return;
        //$cek = $this->master_model->cek_pr1($gb, 'ts_item');
        $cek = $this->master_model->select_in('ms_item as mi left join ts_item as ti ON mi.id=ti.id_item LEFT JOIN (SELECT til.id_ts_item, til.bal_qty from ts_item_log as til GROUP BY til.id_item) as detail ON detail.id_ts_item=ti.id', 'mi.Slider_Code, mi.id_category, mi.id_capacity, mi.cavity, mi.Qty_Per_Shoot, mi.Dieset_Name, ti.in_qty, ti.out_qty, (ti.in_qty-ti.out_qty) as avail','WHERE mi.code LIKE "'.$item.'" and mi.name LIKE "'.$number.'" AND (ti.in_qty-ti.out_qty) > 0 ORDER BY avail ASC');
             //$cek = $this->master_model->cek_put_mo($en_no);
            if ($cek != null) { 

                $resp = [ 
                 'id_mub'          => $cek[0]->id_category, 
                 'id_capacity'     => $cek[0]->id_capacity, 
                 'cavity'          => $cek[0]->cavity,
                 'Qty_Per_Shoot'   => $cek[0]->Qty_Per_Shoot,
                 'in_qty'          => $cek[0]->in_qty, 
                 'out_qty'         => $cek[0]->out_qty, 
                 'avail_qty'          => $cek[0]->avail, 
                 'Slider_Code'          => $cek[0]->Slider_Code,
                 //'id_current_item' =>  $cek[0]->id_current_item,            
                'Dieset_Name'   => $cek[0]->Dieset_Name,                
                 'status'  => true,
                 ];              
                echo json_encode($resp);
                return;
                // echo json_encode($cek);
                // return;
            } else {               
                echo json_encode($cek);
                return;
            }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }


    public function get_ms_item()
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;
        $item = $this->input->post('item');
        $number = $this->input->post('number');
        $gb = $item.' - '.$number;
        header('Content-Type: application/json');
        // echo json_encode($gb);
        // return;
        $cek = $this->master_model->select_in('ms_item', "ms_item.*,DATE_FORMAT(ms_item.created_at, '%d %b %Y') as date",'WHERE code="'.$item.'" and name="'.$number.'"');
             //$cek = $this->master_model->cek_put_mo($en_no);
             $resp = [
                //'message' => 'paint exist on ' . $cek->name,
                'Dieset_Name'   => $cek[0]->Dieset_Name,
                'unit_weight'   => $cek[0]->unit_weight,
                'Qty_Per_Shoot' => $cek[0]->Qty_Per_Shoot,
                'Cavity'        => $cek[0]->Cavity,
                'Slider_Code'   => $cek[0]->Slider_Code,
                'created_at'    => $cek[0]->created_at,
                'regist_date'   => $cek[0]->date,
                'status'  => false,
            ];
             echo json_encode($resp);
                return;
                // if ($cek != null) {                
                //     echo json_encode($cek);
                //     return;
                // } else {               
                //     echo json_encode($cek);
                //     return;
                // }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }


    public function sample_color_put($en_no)
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;
        //$en_no = $this->input->post('en_no');
        // $number = $this->input->post('number');
        // $gb = $item.' - '.$number;
        header('Content-Type: application/json');
        // echo json_encode($gb);
        // return;
        //$cek = $this->master_model->cek_pr1($gb, 'ts_item');
        $cek = $this->master_model->select_in('ts_item as ti left join ms_unit_bin as mub ON ti.id_unit_bin=mub.id LEFT JOIN ms_item as mi ON ti.id_item=mi.id', 'ti.id_item, mub.code, mi.code as codemi, mi.name as namemi, ti.in_qty','WHERE ti.in_code="'.$en_no.'"');
             //$cek = $this->master_model->cek_put_mo($en_no);
            if ($cek != null) { 

                $resp = [                
                'code'   => $cek[0]->code,
                'nm'     => $cek[0]->namemi,
                'qty'    => $cek[0]->in_qty,                
                'status'  => true,
                 ];              
                echo json_encode($resp);
                return;
                // echo json_encode($cek);
                // return;
            } else {   
                 $cek1 = $this->master_model->select_in('ms_item as mi', 'mi.id as idmi, mi.code as codemi, mi.name as namemi, mi.note','WHERE mi.code="'.$en_no.'"');
                $resp1 = [ 'nm' => $cek1[0]->namemi,
                            'note' => $cek1[0]->note,
                            'id'   => $cek1[0]->idmi,

                        ];            
                echo json_encode($resp1);
                return;
            }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }


    public function get_location_put_sample()
    {   
        header('Content-Type: application/json');
        $unit        = $this->MasterUnit->where('id', 2)->get();
        //$in_weight   = $this->input->post('kg');
        $in_code     = $this->input->post('en_no');
        $item_code   = $this->input->post('item_color_code');
        //$in_weight   = 5;

        //cari lokasi bin yg kosong
        $sql = "SELECT mib.* from ms_unit_bin as mib
                inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                WHERE mib.id_current_item = 0
                and mib.id_unit =5 and mib.id_capacity =8
                order by mib.code ASC limit 1";

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            echo json_encode([
                'success' => false,
                'msg'     => 'no more space in unit',
            ]);
            die;
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $id_unit_Bin = $unitBin->id;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        //$code_unit_Bin1 = $unitBin->code;
        $kata="Please store item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth ;

        // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

        // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        // $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        
         echo json_encode([
                'success' => true,
                'msg'     => $kata,
                //'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
            ]);

    }

    //insert put paint
    public function insert_put_sample()
    {
        // $this->load->library('form_validation');
        // $this->form_validation->set_rules('min_text_field', 'Text Field Two', 'required|min_length[8]');

        // if ($this->form_validation->run() == FALSE)
        // {
        //     $this->load->view('validate_form');
        // }
        // else
        // {
        //     // load success template...
        //     echo "It's all Good!";
        // }

        date_default_timezone_set('Asia/Jakarta');
        $date_now    = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1    = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_qty   = $this->input->post('kg_');
        // $section     = $this->input->post('section');
        $submit      = $this->input->post('submit');
        $compartment = $this->input->post('compartment');
        //$unit        = $this->MasterUnit->where('id', 2)->get();
        //$weight = $this->input->post('weight');
        $weight  = 0;
        $section = 0;
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $quantity = $this->input->post('quantity');
        $id_ms_item = $this->input->post('id_item');
        $number = $this->input->post('number');        

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');
       $idmi = $this->input->post('idmi');    
            
                $id_ts_item = $this->TransaksiItem->getLastId();

                // if($idmi == null){
                //     $idmi1 = $this->MasterItem->getLastId();
                // } else {
                //     $idmi1 = $idmi;
                // }

                 $data_ms_item = [
                    'id_category' => 5,
                    'id_capacity' => 8,
                    'code'        => $this->input->post('en_no'),
                    'name'        => $this->input->post('nm_code'),
                    'unit_weight' => 0,
                    'note'        => $this->input->post('note'),
                ];

                 if($idmi == null){
                        $this->MasterItem->insert($data_ms_item);                 
                        //$idmi1 = $this->MasterItem->getLastId();
                        $idmi1 = $this->master_model->mst_last_id_new('ms_item');
                    } else {
                        $this->MasterItem->where('id', $idmi)->update($data_ms_item);
                        //$this->TransaksiItem->where('id', $tsItem->id)->update($data_ts_item);
                        $idmi1 = $idmi;
                }

         $data_item = [
            'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $idmi1,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => $weight,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => $quantity,
            'out_qty'     => 0,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'in_code'     => $in_code1,           
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $idmi1,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => $quantity,
            'status'      => 'PUT',
            'out_kg'      => 0,
            'out_qty'     => 0,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            'bal_qty'     => 1,
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        //echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
        // print_r($data_ts_item);
        //print_r([$cek,$in_code1,$in_code, $data_item, $data_log,$data_ms_item, $_POST]);
        
        //die;
        $this->db->trans_start();
        

        if ($cek == null) {
                   
                        // insert ke ts_item
                        $this->TransaksiItem->insert($data_item);
                        // insert ke ts_item_log
                         $this->MasterItemLog->insert($data_log);

                         $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                            'id_current_item' => $id_ts_item,
                    ]);
             } else {
                        //update time stamp master
                        //$this->MasterItem->updated_at($id_item);
                        echo "failed";
                        $this->session->set_flashdata('messages', '<div class="alert alert-danger">Add Put Failed</div>');
                        redirect('admin_home/sample_put_new');
            } 

          
        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
     
        if ($submit == 'save') {
            // redirect
            $this->session->set_flashdata('messages', '<div class="alert alert-success">Add Put succes</div>');
            redirect('admin_home/index/8.php');
            
        } else {
            $this->session->set_flashdata('messages', '<div class="alert alert-success">Add Put succes</div>');
            redirect('admin_home/sample_put_new');
        }        

    }


      //save pick paint
    public function insert_pick_sample()
    {
        date_default_timezone_set('Asia/Jakarta');
        $date_now = date('Y-m-d h:i:s');           
        $UserName      = $this->session->userdata('id');
        //$pr_no        = strtoupper(trim($this->input->post('pr_no')));
        //$item_code    = strtoupper(trim($this->input->post('item_code')));
        
        $avail_weight = $this->input->post('avail_weight');
        $out_weight   = $this->input->post('out_weight');
        $last_out_kg  = $this->input->post('last_out_kg');
        $last_dif_kg  = $this->input->post('last_dif_kg');
        $last_out_qty  = $this->input->post('pick_qty');
       
        $id_ts_item      = $this->input->post('id_ts_item');
        //$id_ts_item = $this->TransaksiItem->getLastId();
        
        $in_code1      = $this->input->post('en_no');
        //$in_code     = $this->MasterItem->clean_in_code($in_code1);
        // $en_code   = $this->input->post('en_code');
        $note   = $this->input->post('note');
        $submit = $this->input->post('submit');
        //echo $last_out_kg." + ".$out_weight;die();
        $weight  = 0;
        $section = 0;
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $quantity = $this->input->post('pick_qty');
        $id_ms_item = $this->input->post('id_item');
        $number = $this->input->post('number');        

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($in_code1, 'ts_item');
       $idmi = $this->input->post('id_item');    
        
        // $data_ts_item = [
        //     'id_user'       => $UserName,
        //     'note'          => $note,
        //     'out_kg'        => 0,
        //     'dif_kg'        => 0,
        //     'out_qty'       => $last_out_qty,
        //     'is_active'     => 0,
        //     'last_activity' => date("Y/m/d"),
        // ];

        $data_item = [
            //'id'          => $id_ts_item,
            'in_code'     => $in_code1,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $idmi,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => $weight,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => 0,
            'out_qty'     => $quantity,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            'out_code'    => $in_code1,           
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $idmi,            
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => 0,
            'status'      => 'PICK',
            'out_kg'      => 0,
            'out_qty'     => $quantity,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

         //echo "<pre>";
        // print_r($data_ts_item);
        // print_r($data_log);
        // print_r($_POST);
         //print_r($this->db->queries);
        //print_r([$in_code1, $data_item, $data_log, $_POST]);
         //die;

        $this->db->trans_start();
        //update ms_item
        $this->MasterItem->updated_at($idmi);   
             // insert ke ts_item
                        //$this->TransaksiItem->insert($data_item);
                        // insert ke ts_item_log
                $this->TransaksiItem->where('id', $id_ts_item)->update([
                'last_activity' => date("Y-m-d"),
                //'in_qty'        => $to_in,
                'out_qty'       => $quantity,
                'note'          => $note,
                //'updated_at' => date("Y-m-d H:i:s"),
                ]);
                         $this->MasterItemLog->insert($data_log);

                  $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                            'id_current_item' => 0,
                    ]);

        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
             $this->session->set_flashdata('messages', 'Add Pick Failed');
            // $this->session->set_flashdata('message', '<div class="alert alert-danger">Add Pick Failed</div>');
                        redirect('admin_home/sample_pick_new');
            //echo "data gagal";
        }

        if ($submit == 'save') {
            $this->session->set_flashdata('messages', 'Add Pick succes');
            //$this->session->set_flashdata('message', '<div class="alert alert-success">Add Pick succes</div>');
            redirect('admin_home/index/8.php');
        }

        if ($submit == 'save_and_pick') {
            // redirect
             $this->session->set_flashdata('messages', 'Add Pick succes');
            //$this->session->set_flashdata('message', '<div class="alert alert-success">Add Pick succes</div>');
            redirect('admin_home/sample_pick_new');
        }
        // echo "dara sukmses";
        // echo "sukses";
    }


    public function sample_color_pick($en_no)
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;
        //$en_no = $this->input->post('en_no');
        // $number = $this->input->post('number');
        // $gb = $item.' - '.$number;
        header('Content-Type: application/json');
        // echo json_encode($gb);
        // return;
        $cekl = $this->master_model->select_in('ts_item_log as til', 'til.id', 'WHERE til.out_code="'.$en_no.'"');
        if($cekl != null){
             $resp1 = [                           
                            'status'  => false,
                            'message' => 'Color Code Exsis',
                        ];          
            echo json_encode($resp1);
            return;
        }
        //$cek = $this->master_model->cek_pr1($gb, 'ts_item');
        $cek = $this->master_model->select_in('ts_item as ti left join ms_unit_bin as mub ON ti.id_unit_bin=mub.id LEFT JOIN ms_item as mi ON ti.id_item=mi.id', 'ti.id as idtsi, ti.id_item, mub.code, mub.id as idmub, mi.code as codemi, mi.name as namemi, ti.in_qty','WHERE ti.in_code="'.$en_no.'" ORDER BY mub.code ASC');
             //$cek = $this->master_model->cek_put_mo($en_no);
            if ($cek != null) { 

                $resp = [   
                'id_ts_item' => $cek[0]->idtsi,
                'id_item'    => $cek[0]->id_item,             
                'code'       => $cek[0]->code,
                'id'         => $cek[0]->idmub,
                'nm'         => $cek[0]->namemi,
                'qty'        => $cek[0]->in_qty,                
                'status'     => true,
                 ];              
                echo json_encode($resp);
                return;
                // echo json_encode($cek);
                // return;
            } else {   
                 // $cek1 = $this->master_model->select_in('ms_item as mi', 'mi.id as idmi, mi.code as codemi, mi.name as namemi, mi.note','WHERE mi.code="'.$en_no.'"');
                $resp1 = [ 
                            // 'nm' => $cek1[0]->namemi,
                            // 'note' => $cek1[0]->note,
                            // 'id'   => $cek1[0]->idmi,
                            'status'  => false,
                            'message' => 'Color Code No PUT',
                        ];            
                echo json_encode($resp1);
                return;
            }
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }


    // find location for put paint
    public function get_location_pick_sample()
    {   
        header('Content-Type: application/json');
        $unit        = $this->MasterUnit->where('id', 5)->get();
        $in_weight   = $this->input->post('kg');
        $in_code     = $this->input->post('en_no');
        $idmub       = $this->input->post('idmub');
        $item_code   = $this->input->post('item_color_code');
        //$in_weight   = 5;
         //cari lokasi bin yg kosong
        $sql = "SELECT mib.* from ms_unit_bin as mib
                inner JOIN ms_unit_capacity as muc on muc.id=mib.id_capacity
                WHERE mib.id = $idmub AND mib.id_current_item != 0
                and mib.id_unit =5 and mib.id_capacity =8
                order by mib.code ASC limit 1";

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            echo json_encode([
                'success' => false,
                'msg'     => 'no more space in unit',
            ]);
            die;
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $id_unit_Bin = $unitBin->id;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        //$code_unit_Bin1 = $unitBin->code;
        $kata="Please pick item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth ;

        // $base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
        // $playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

        // $client = new GuzzleHttp\Client(['base_uri' => $base_url]);

        // $resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        
         echo json_encode([
                'success' => true,
                'msg'     => $kata,
                //'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
            ]);

    }


    // find location for put paint
    public function get_location_pick_molding()
    {   
        header('Content-Type: application/json');
        $unit        = $this->MasterUnit->where('id', 2)->get();
        $in_weight   = $this->input->post('kg');
        $in_code     = $this->input->post('en_no');
        $item_code   = $this->input->post('item_color_code');
        $self        = $this->input->post('self');
        //$in_weight   = 5;
        //       
        $gb = $in_code.'-'.$item_code;
        
        // echo json_encode($gb);
        // return;
        //$cek = $this->master_model->cek_pr1($gb, 'ts_item');
        $cek = $this->master_model->select_in('ts_item as ti left join ms_unit_bin as mub ON ti.id_unit_bin=mub.id', 'ti.id_item, ti.id_item, ti.in_qty, ti.out_qty,mub.id as id_mub, mub.code, mub.id_current_item, (ti.in_qty-ti.out_qty) as avail','WHERE ti.in_code="'.$gb.'" and (ti.in_qty-ti.out_qty) > 0 ORDER BY `avail` ASC limit 1');
                @$code_bin = $cek[0]->code;

                if ($cek == null) { 
                    echo json_encode([
                     'success' => false,
                      'msg'     => 'no more space in unit Pick',
                    $cek
                ]);
                return;

                
                // echo json_encode($cek);
                // return;
            } 
        //////
                 $id_cpa = $this->master_model->cek_put_mo1($item_code, $in_code);            
                 $id_cp = $id_cpa->id_capacity;
        //cari lokasi bin yg kosong
         $sql = "SELECT mib.* from ms_unit_bin as mib
                WHERE mib.id_current_item > 0
                and mib.id_unit =6 AND mib.shelf = '$self' AND mib.id_capacity ='$id_cp'
                order by mib.code DESC limit 1";

        $unitBin = $this->db->query($sql)->row();
        if ($unitBin == null) {
            echo json_encode([
                'success' => false,
                'msg'     => 'no more space in unit',
            ]);
            die;
        }
        $ip                   = $unit->ip;
        $port                 = $unit->port;
        $id_unit_Bin = $unitBin->id;
        $unit_bin_shelf       = $unitBin->shelf;
        $unit_bin_compartment = $unitBin->compartment;
        $static_depth         = $unit->static_depth;
        if ($static_depth == 0) {
            $unit_bin_depth       = $unitBin->depth;
        } else {
            $unit_bin_depth = $static_depth;
        }

        //$code_unit_Bin1 = $unitBin->code;
        $kata="Please store item on shelf : " .$unit_bin_shelf . " and compartment no : ". $unit_bin_compartment . " and depth : ". $unit_bin_depth ;

            //$base_url = str_replace('storage/', '', base_url()) . 'hanelapi/v2/6t2cZ1J4Yi/hanel/' . $ip . '/' . $port . '/shelf/';
            //$playload = 'get?shelf_number=' . $unit_bin_shelf . '&compartment=' . $unit_bin_compartment . '&depth=' . $unit_bin_depth . '&desc1=' . $in_code . '&desc2=' . $item_code . '&desc3=' . $in_weight. '';

            //$client = new GuzzleHttp\Client(['base_uri' => $base_url]);

            //$resp = $client->request('GET', $playload);
        // echo $base_url . $playload;
        // echo "<br>";
        // echo $resp->getBody();
        // die;
        
         echo json_encode([
                'success' => true,
                'msg1'     => $kata,
                //'resp'    => $resp,
                //'api_hanel_response' => $resp,
                'unitBin'  => $unitBin,
               
                 'id_mub'          => $cek[0]->id_mub, 
                'id_item'          => $cek[0]->id_item, 
                'out_qty'          => $cek[0]->out_qty, 
                'in_qty'          => $cek[0]->in_qty, 
                'id_current_item' =>  $cek[0]->id_current_item,            
                'code'   => $cek[0]->code,                
                'status'  => true,
                'msg'     => 'Pick Location ' . $cek[0]->code,
                

            ]);

    }


    //insert put paint
    public function insert_pick_molding()
    {
        // $this->load->library('form_validation');
        // $this->form_validation->set_rules('min_text_field', 'Text Field Two', 'required|min_length[8]');

        // if ($this->form_validation->run() == FALSE)
        // {
        //     $this->load->view('validate_form');
        // }
        // else
        // {
        //     // load success template...
        //     echo "It's all Good!";
        // }

        date_default_timezone_set('Asia/Jakarta');
        $date_now    = date('Y-m-d h:i:s');
        $UserName    = $this->session->userdata('id');
        $note        = $this->input->post('note');
        $in_code1    = strtoupper(trim($this->input->post('en_no')));
        $in_code     = $this->MasterItem->clean_in_code($in_code1);
        $item_code   = strtoupper(trim($this->input->post('item_color_code')));
        $create_date = $this->input->post('item-date-create');
        $in_qty      = $this->input->post('kg_');
        // $section     = $this->input->post('section');
        $section     = 0;
        $submit      = $this->input->post('submit');
        $compartment = $this->input->post('compartment');
        //$unit        = $this->MasterUnit->where('id', 2)->get();
        //$weight = $this->input->post('weight');
        $weight      = 0;
        $id_unit_Bin = $this->input->post('id_unit_bin');
        $quantity    = $this->input->post('quantity');
        $id_ms_item  = $this->input->post('id_item');
        $number = $this->input->post('number');
        $incode = $in_code1.'-'.$number;

        $id_ts_item_old = $this->input->post('id_current_item');
        $location       = $this->input->post('location');
        $in_qty_old     = $this->input->post('quantity_old');
        $out_qty_item     = $this->input->post('out_qty_item');
        @$to_in         = $out_qty_item + $quantity;
        @$to_out         = $in_qty_old - $quantity;

        $cavity       = $this->input->post('cavity');
        if($cavity == ""){
            $cavity=0;
        }

       //$cek = $this->master_model->cek_paint_exist($in_code1);
       $cek = $this->master_model->cek_pr1($incode, 'ts_item');
       
       $cek1 = $this->master_model->select_in('ms_unit_bin as mib','mib.*',"WHERE mib.id_current_item = 0
                and mib.id_unit =6 AND mib.code = '$location' order by mib.code DESC limit 1");

       //echo $cek1[0]->id;
       //die;
       //  if ($cek != null) {
       //      echo $cek;
       //      die;
       //  }

        // negecek item
        // $item = $this->MasterItem
        //     ->where('code', $item_code)
        //     ->where('id_category', '2')
        //     ->get();
        
        // if ($cek == null) {
        //     $id_item = $this->MasterItem->getLastId();
        // } else {
        //     $id_item = $item->id;
        // }
        $id_ts_item = $this->TransaksiItem->getLastId();

         $data_item = [
           // 'id'          => $id_ts_item,
            //'in_code'     => $in_code1,
            'out_code'    => $in_code1,
            'id_unit_bin' => $id_unit_Bin,
            'id_item'     => $id_ms_item,
            'id_group'    => $section,
            'store_date'  => date("Y-m-d"),
            'unit_weight' => $weight,
            'exp_qty'     => 0,
            'exp_kg'      => 0,            
            'in_qty'      => 0,
            'out_qty'     => $quantity,
            'in_kg'       => 0,
            'out_kg'      => 0,
            'dif_kg'      => 0,
            'dif_qty'     => 0,
            'is_dasaran'  => 0,
            'is_active'   => 1,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item,
            //'in_code'     => $in_code1,
            'out_code'    => $in_code1,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => 0,
            'status'      => 'PICK',
            'out_kg'      => 0,
            'bal_kg'      => 0,
            'out_qty'     => $quantity,
            'cavity'      => $cavity,
            'bal_qty'     => $to_out,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        $data_log_up = [
            // 'id_category'   => 1,
            'id_ts_item'  => $id_ts_item_old,
            //'in_code'     => $in_code1,
            'out_code'    => $in_code1,
            //'id_unit_bin' => $id_bin,
            'id_item'     => $id_ms_item,
            'id_unit_bin' => $id_unit_Bin,
            'id_group'    => $section,
            'store_date'  => date("Y/m/d"),
            //'last_activity' => date("Y/m/d"),
            'unit_weight' => $weight,
            // 'last_pick'     => date("Y/m/d"),
            'exp_kg'      => 0,
            'exp_qty'     => 0,
            'in_kg'       => 0,
            'in_qty'      => 0,
            'status'      => 'PICK',
            'out_kg'      => 0,
            'bal_kg'      => 0,
            'out_qty'     => $quantity,
            'cavity'      => $cavity,
            'bal_qty'     => $to_out,
            'dif_kg'      => 0,
            // 'dif_kg'      => $out_weight - $avail_weight,
            
            'dif_qty'     => 0,
            'id_user'     => $UserName,
            'note'        => $note,
        ];

        echo "<pre>";
        // print_r($data_log);
        // print_r($data_item);
         //print_r($data_ts_item);
        print_r([$cavity, $cek, $cek1,$to_in,$incode, $data_item, $data_log, $data_log_up, $_POST]);
        
        die;
        $this->db->trans_start();
        //yg lama
        //if($cek1 == null){
            if($to_out != 0){
                //tidak abis
            //update ts_item
            $this->TransaksiItem->where('id', $id_ts_item_old)->update([
                'last_activity' => date("Y-m-d"),
                //'in_qty'        => $to_in,
                'out_qty'       => $to_in,
                'note'          => $note,
                //'updated_at' => date("Y-m-d H:i:s"),
                ]);
            // insert ke ts_item_log
             $this->MasterItemLog->insert($data_log_up);
        } else 
         { //abis == 0
            // insert ke ts_item
                //$this->TransaksiItem->insert($data_item);
            $this->TransaksiItem->where('id', $id_ts_item_old)->update([
                'last_activity' => date("Y-m-d"),
                //'in_qty'        => $to_in,
                'out_qty'       => $to_in,
                'note'          => $note,
                //'updated_at' => date("Y-m-d H:i:s"),
                ]);

            // insert ke ts_item_log
             //$this->MasterItemLog->insert($data_log);
             $this->MasterItemLog->insert($data_log_up);

             $this->MasterUnitBin->where('id', $id_unit_Bin)->update([
                'id_current_item' => 0,
            ]);
        } 

                // else {
                //     //update time stamp master
                //     //$this->MasterItem->updated_at($id_item);
                //     echo "failed";
                //     redirect('admin_home/molding_put_new');
                // }    
        $this->db->trans_complete();

        // jika transaction failed
        if ($this->db->trans_status() === false) {
            echo "failed";
        }
     
        if ($submit == 'save') {
            // redirect
            $this->session->set_flashdata('messages', 'Add data Pick Molding succes');
            redirect('admin_home/index/8.php');
            
        }

        if ($submit == 'save_and_pick_dm') {
            // redirect
            $this->session->set_flashdata('messages', 'Add data Die Cast Pick Molding succes');
            redirect('admin_home/molding_pick_new/dm');
        } elseif ($submit == 'save_and_pick_dd')
        {
            $this->session->set_flashdata('messages', 'Add data Die Cast Set Pick Molding succes');
             redirect('admin_home/molding_pick_new/dd');
        } elseif ($submit == 'save_and_pick_rm')
        {
            $this->session->set_flashdata('messages', 'Add data Rubber Pick Molding succes');
             redirect('admin_home/molding_pick_new/rm');
        } elseif ($submit == 'save_and_pick_as')
        {
            $this->session->set_flashdata('messages', 'Add data Assembling SHO Molding succes');
             redirect('admin_home/molding_pick_new/as');
        }
        //echo "successful";


    }

    public function en_no_pick_molding($en_no)
    {
        // $hanel_api = $this->master_model->select_in('config_global', 'hanelapikey', "WHERE ID=1");
        // $api_hanel = $hanel_api[0]->hanelapikey;       
        header('Content-Type: application/json');
        // echo json_encode($gb);
        // return;
        //$cek = $this->master_model->cek_pr1($gb, 'ts_item');
        $cek = $this->master_model->select_in('ts_item_log as ti left join ms_unit_bin as mub ON ti.id_unit_bin=mub.id LEFT JOIN ms_item as mi ON ti.id_item=mi.id', 'ti.id_item, mub.code, mi.code as codemi, mi.name as namemi, ti.in_qty','WHERE ti.out_code LIKE"'.$en_no.'"');
             //$cek = $this->master_model->cek_put_mo($en_no);
            if ($cek != null) { 

                // $resp = [                
                // 'code'   => $cek[0]->code,
                // 'nm'     => $cek[0]->namemi,
                // 'qty'    => $cek[0]->in_qty,                
                // 'status'  => true,
                //  ];              
                // echo json_encode($resp);
                // return;
                // 
                $resp = [
                  'message'  => 'PR No exist ' . $en_no,
                  'status'   => true,
                        ];
                 echo json_encode($resp);
                 return;
                // echo json_encode($cek);
                // return;
            } else {   
                 $resp = [
                  'message'  => 'PR No no exist ' . $en_no,
                  'status'   => false,
                        ];
                 echo json_encode($resp);
                 return;
               
            }

            ///////////////////////
            ///////////////////
        $cek = $this->master_model->cek_sparepart_exist($en_no);
        $id_item = $cek->id_item;
        $cek_code = $this->master_model->select_in('ms_item', 'code', "WHERE id=$id_item");
            $code_ms_item = $cek_code[0]->code;
        $id_msunib = $cek->id_bin_group;
         $cek1 = $this->master_model->cek_code_group3($id_msunib, $cek->id_unit);
         $id_crnt = $cek->id_current_item;
         if($id_crnt == '0'){
            $resp = [
                'message'  => 'paint exist on ' . $cek->code,
                'status'   => false,
            ];
             echo json_encode($resp);
            return;
         }
        if ($id_crnt != null) {
            $resp1 = [
                'message' => 'paint exist on ' . $cek->code,
                'result'  => $cek,
                'result1' => $cek->id_unit,
                'result2' => $cek->id_bin_group,
                'cek1'    => $cek1,
                'id_ts_item'   => $cek->id_current_item,
                'in_qty'       => $cek->in_qty,
                'code_ms_item' => $code_ms_item,
                'status'       => true,
            ];

            echo json_encode($resp1);
            return;
        }
        echo json_encode($en_no);
        // $client = new GuzzleHttp\Client(['base_uri' => str_replace('storage/', '', base_url()) . 'hanelapi/v2/' . $api_hanel . '/paint/put/']);

        // $response = $client->request('GET', $en_no);

        // $body = $response->getBody();
        // echo $body;
    }


}
