<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

use Symfony\Component\VarDumper\VarDumper;

if (!function_exists('dd')) {
    function dd($var)
    {
        foreach (func_get_args() as $var) {
            VarDumper::dump($var);
        }
        die();
    }
}

if ( ! function_exists('print_array'))
{
	function print_array($data)
	{
		echo "<pre>"; print_r($data); echo "</pre>";
	}	
}

 function RepSpecCharWiqi($str)
	{
		$str = str_replace(" ",'-',$str); // '
		$str = str_replace("'",'-',$str); // '
		$str = str_replace('"','-',$str); // "
		$str = str_replace("?",'-',$str); // ?
		$str = str_replace("&",'-',$str); // &
		$str = str_replace("!",'-',$str); // !
		$str = str_replace("@",'-',$str); // @
		$str = str_replace("#",'-',$str); // #
		$str = str_replace("$",'-',$str); // $
		$str = str_replace("%",'-',$str); // %
		$str = str_replace("^",'-',$str); // ^
		$str = str_replace("*",'-',$str); // *
		$str = str_replace("(",'-',$str); // (
		$str = str_replace(")",'-',$str); // )
		$str = str_replace("{",'-',$str); // {
		$str = str_replace("}",'-',$str); // }
		$str = str_replace("[",'-',$str); // [
		$str = str_replace("]",'-',$str); // ]
		$str = str_replace(">",'-',$str); // >
		$str = str_replace("<",'-',$str); // <
		$str = str_replace(",",'-',$str); // ,
		$str = str_replace(".",'-',$str); // .
		$str = str_replace("=",'-',$str); // =
		$str = str_replace("|",'-',$str); // |
		$str = str_replace("/",'-',$str); // /
		$str = str_replace("\\",'-',$str); // \
		$str = str_replace(";",'-',$str); // ;
		$str = str_replace(":",'-',$str); // :
		
		return $str; 
	}

	if (!function_exists('asset')) {
    function asset($path)
    {
        return base_url() . 'assets/vendor' . $path;
    }
}

if (!function_exists('clean')) {
    function clean($string)
    {
        return preg_replace('/\s+/S', " ", strip_tags($string));
    }
}

if (!function_exists('remove_icon')) {
    function remove_icon($image, $id)
    {
        if ($image == '') {
            return 'no image';
        } else {
            return '
            <button
                type="button"
                class="btn btn-flat btn-xs btn-primary image-btn"
                data-id="' . $id . '"
                data-image="' . $image . '"
            >
                Remove Image
            </button>
            ';
        }
    }
}

if (!function_exists('js')) {
    function js($path)
    {
        return base_url() . 'assets/js' . $path;
    }
}

if (!function_exists('img')) {
    function img($path)
    {
        return base_url() . 'assets/img' . $path;
    }
}

if (!function_exists('my_base_url')) {
    function my_base_url($path)
    {
        return base_url() . $path;
    }
}

if (!function_exists('dd')) {
    /**
     * @author Nicolas Grekas <p@tchwork.com>
     */
    function dd($var)
    {
        foreach (func_get_args() as $var) {
            VarDumper::dump($var);
        }
        die();
    }
}

if (!function_exists('edit_btn')) {
    function edit_btn($link = "", $submit = false)
    {
        if ($submit) {
            return '<button type="submit" class="btn btn-flat btn-sm bg-purple"><i class="fa fa-pencil"></i> ' . $link . '</button>';
        } else {
            $url = base_url() . $link;
            return "<a href='" . $url . "' class='btn btn-flat btn-xs btn-success'><i class='fa fa-pencil'></i> Edit</a>";
        }
    }
}

if (!function_exists('add_btn')) {
    function add_btn($link = "", $submit = false, $text = 'add')
    {
        if ($submit) {
            return '<button type="submit" class="btn btn-flat btn-sm bg-purple"><i class="fa fa-plus"></i> ' . $link . '</button>';
        } else {
            $url = base_url() . $link;
            return "<a href='" . $url . "' class='btn btn-flat btn-sm bg-purple'><i class='fa fa-plus'></i> ".$text."</a>";
        }
    }
}

if (!function_exists('view_btn')) {
    function view_btn($link = "", $text = "view", $submit = false)
    {
        if ($submit) {
            return '<button type="submit" class="btn btn-flat btn-xs bg-navy"><i class="fa fa-eye"></i> ' . $link . '</button>';
        } else {
            $url = base_url() . $link;
            return "<a href='" . $url . "' class='btn btn-flat btn-xs bg-navy'><i class='fa fa-eye'></i> " . $text . "</a>";
        }
    }
}

if (!function_exists('publish_btn')) {
    function publish_btn($publish, $type = 'submit')
    {
        if ($publish == 1) {
            return '<button type="submit" class="btn btn-flat btn-xs btn-warning publish-btn"><i class="fa fa-check"></i> Publish</button>';
        } else {
            return '<button type="submit" class="btn btn-flat btn-xs btn-warning publish-btn"><i class="fa fa-close"></i> Publish</button>';
        }
    }
}

if (!function_exists('mainflag_icon')) {
    function mainflag_icon($mainflag)
    {
        if ($mainflag == 1) {
            return '<i class="fa fa-check"></i>';
        } else {
            return '<i class="fa fa-close"></i>';
        }
    }
}

if (!function_exists('publish_icon')) {
    function publish_icon($publish)
    {
        if ($publish == 1) {
            return '<i class="fa fa-check"></i>';
        } else {
            return '<i class="fa fa-close"></i>';
        }
    }
}

if (!function_exists('is_footer_icon')) {
    function is_footer_icon($footer)
    {
        if ($footer == 1) {
            return '<i class="fa fa-check"></i>';
        } else {
            return '<i class="fa fa-close"></i>';
        }
    }
}

if (!function_exists('check_permissions')) {
    function check_permissions($check, $data)
    {
        foreach ($data as $d) {
            if ($d->id == $check) {
                return true;
                break;
            }
        }

        return false;
    }
}

if (!function_exists('btn_img')) {
    function btn_img($id, $data, $word = 'Add image')
    {
        if (!empty($data)) {
            foreach ($data as $no => $d) {
                $text = $d->counted_rows;
            }
            $icon = '<i class="fa fa-image"></i>';
        } else {
            $text = $word;
            $icon = '<i class="fa fa-plus"></i>';
        }

        $url = my_base_url('admin/product_images/create/' . $id);

        return '<a href="' . $url . '" class="btn btn-flat btn-xs bg-maroon">' . $icon . ' ' . $text . '</a>';
    }
}

if (!function_exists('product_image_count')) {
    function product_image_count($id, $data, $word = 'Add image')
    {
        if (!empty($data)) {
            foreach ($data as $no => $d) {
                $text = $d->counted_rows;
            }
        } else {
            $text = 0;
        }

        $url = base_url() . 'admin/product_images/show/' . $id;
        return "<a href='" . $url . "' class='btn btn-flat btn-xs bg-navy' data-toggle='tooltip' title='view product image'><i class='fa fa-eye'></i> " . $text . "</a>";
    }
}

if (!function_exists('format_rupiah')) {
    function format_rupiah($input)
    {
        $hasil = 'Rp.' . number_format($input, 0, ',', '.');
        return $hasil;
    }
}

if (!function_exists('format_kg')) {
    function format_kg($input)
    {
        $hasil = number_format($input, 0, ',', '.') . ' Kg';
        return $hasil;
    }
}

if (!function_exists('byte_format')) {
    function byte_format($bytes, $precision = 2)
    {
        $units = array('B', 'KB', 'MB', 'GB', 'TB');

        $bytes = max($bytes, 0);
        $pow   = floor(($bytes ? log($bytes) : 0) / log(1024));
        $pow   = min($pow, count($units) - 1);

        // Uncomment one of the following alternatives
        // $bytes /= pow(1024, $pow);
        // $bytes /= (1 << (10 * $pow));

        return round($bytes, $precision) . ' ' . $units[$pow];
    }
}

if (!function_exists('getImgMainflag')) {
    function getImgMainflag($images, $replace = 'https://www.freeiconspng.com/uploads/no-image-icon-13.png')
    {
        $ada = false;
        if ($images != false) {
            foreach ($images as $image) {
                if ($image->mainflag == 1) {
                    $replace = $image->image_full;
                    $ada     = true;
                    break;
                }
            }
        }

        if ($ada) {
            return img('/uploads/products/' . $replace);
        }

        return $replace;
    }
}

if (!function_exists('array_random')) {
    function array_random($arr, $num = 1)
    {
        shuffle($arr);

        $r = array();
        for ($i = 0; $i < $num; $i++) {
            $r[] = $arr[$i];
        }
        return $r[0];
    }
}

if (!function_exists('contract_status')) {
    function contract_status($stat)
    {
        switch ($stat) {
            case 'New':
                return array(
                    'color'           => 'btn-primary',
                    'color-available' => 'bg-maroon',
                    'text'            => 'new',
                    'available'       => 'ship',
                    'data-toggle'     => 'modal',
                    'data-target'     => '#modal-default');
                break;

            case 'Process':
                return array(
                    'color'           => 'btn-warning',
                    'color-available' => 'bg-navy',
                    'text'            => 'Process',
                    'available'       => 'ship',
                    'data-toggle'     => 'modal',
                    'data-target'     => '#modal-default');
                break;

            case 'Close':
                return array(
                    'color'           => 'btn-danger',
                    'color-available' => 'btn-danger',
                    'text'            => 'Close',
                    'available'       => 'Invoice',
                    'data-toggle'     => 'modal',
                    'data-target'     => '#modal-invoice');
                break;

            default:
                return $stat;
                break;
        }
    }
}

if (!function_exists('contract_status_color')) {
    function contract_status_color($stat)
    {
        switch ($stat) {
            case 'New':
                return 'btn-primary';
                break;

            case 'Process':
                return 'btn-warning';
                break;

            case 'Close':
                return 'btn-danger';
                break;

            default:
                return '';
                break;
        }
    }
}

if (!function_exists('array_column')) {
    /**
     * Returns the values from a single column of the input array, identified by
     * the $columnKey.
     *
     * Optionally, you may provide an $indexKey to index the values in the returned
     * array by the values from the $indexKey column in the input array.
     *
     * @param array $input A multi-dimensional array (record set) from which to pull
     *                     a column of values.
     * @param mixed $columnKey The column of values to return. This value may be the
     *                         integer key of the column you wish to retrieve, or it
     *                         may be the string key name for an associative array.
     * @param mixed $indexKey (Optional.) The column to use as the index/keys for
     *                        the returned array. This value may be the integer key
     *                        of the column, or it may be the string key name.
     * @return array
     */
    function array_column($input = null, $columnKey = null, $indexKey = null)
    {
        // Using func_get_args() in order to check for proper number of
        // parameters and trigger errors exactly as the built-in array_column()
        // does in PHP 5.5.
        $argc   = func_num_args();
        $params = func_get_args();

        if ($argc < 2) {
            trigger_error("array_column() expects at least 2 parameters, {$argc} given", E_USER_WARNING);
            return null;
        }

        if (!is_array($params[0])) {
            trigger_error(
                'array_column() expects parameter 1 to be array, ' . gettype($params[0]) . ' given',
                E_USER_WARNING
            );
            return null;
        }

        if (!is_int($params[1])
            && !is_float($params[1])
            && !is_string($params[1])
            && $params[1] !== null
            && !(is_object($params[1]) && method_exists($params[1], '__toString'))
        ) {
            trigger_error('array_column(): The column key should be either a string or an integer', E_USER_WARNING);
            return false;
        }

        if (isset($params[2])
            && !is_int($params[2])
            && !is_float($params[2])
            && !is_string($params[2])
            && !(is_object($params[2]) && method_exists($params[2], '__toString'))
        ) {
            trigger_error('array_column(): The index key should be either a string or an integer', E_USER_WARNING);
            return false;
        }

        $paramsInput     = $params[0];
        $paramsColumnKey = ($params[1] !== null) ? (string) $params[1] : null;

        $paramsIndexKey = null;
        if (isset($params[2])) {
            if (is_float($params[2]) || is_int($params[2])) {
                $paramsIndexKey = (int) $params[2];
            } else {
                $paramsIndexKey = (string) $params[2];
            }
        }

        $resultArray = array();

        foreach ($paramsInput as $row) {
            $key    = $value    = null;
            $keySet = $valueSet = false;

            if ($paramsIndexKey !== null && array_key_exists($paramsIndexKey, $row)) {
                $keySet = true;
                $key    = (string) $row[$paramsIndexKey];
            }

            if ($paramsColumnKey === null) {
                $valueSet = true;
                $value    = $row;
            } elseif (is_array($row) && array_key_exists($paramsColumnKey, $row)) {
                $valueSet = true;
                $value    = $row[$paramsColumnKey];
            }

            if ($valueSet) {
                if ($keySet) {
                    $resultArray[$key] = $value;
                } else {
                    $resultArray[] = $value;
                }
            }

        }

        return $resultArray;
    }
 }