<!-- Include Bootstrap Table CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-table@1.18.3/dist/bootstrap-table.min.css" rel="stylesheet">

<!-- Include Bootstrap Table JS and jQuery -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap-table@1.18.3/dist/bootstrap-table.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Tampilkan tabel dengan Bootstrap Table -->
<table id="data-table"
    data-toggle="table"
    data-pagination="true"
    data-page-size="10"
    data-url="<?php echo base_url('data/get_data');?>"
    data-side-pagination="server"
    data-query-params="queryParams"
    data-search="true"
    >
    <thead>
        <tr>
            <th data-field="id" data-sortable="true">ID</th>
            <th data-field="nama" data-sortable="true">Nama</th>
            <th data-field="kategori" data-sortable="true">Kategori</th>
            <th data-field="deskripsi" data-sortable="true">Deskripsi</th>
        </tr>
    </thead>
</table>

<!-- Script untuk membuat tombol "View More" -->
<script>
    // Fungsi untuk mengambil data dari server
    function queryParams(params) {
        params.limit = params.limit || 10; // Limit data per halaman
        params.offset = params.offset || 0; // Offset data
        return params;
    }

    // Tambahkan kolom "View More" ke dalam tabel
    function operateFormatter(value, row, index) {
        return [
            '<a class="btn btn-info" href="<?php echo base_url('data/viewmore');?>/' + row.id + '">View More</a>',
        ].join('');
    }

    // Tambahkan kolom "View More" ke dalam tabel
    $(function () {
        $('#data-table').bootstrapTable({
            columns: [{
                field: 'operate',
                title: 'Actions',
                formatter: operateFormatter,
                width: 100,
            }],
        });
    });
</script>
