<script>
  $(function() {
    var $table = $('#table');

    $table.bootstrapTable({
      url: '<?php echo base_url('products/get_data') ?>',
      queryParams: function(params) {
        params.search = $('#search').val();
        params.category_id = $('#category').val();
        return params;
      },
      sidePagination: 'server',
      pagination: true,
      pageSize: 10,
      pageList: [10, 25, 50, 100],
      search: true,
      sortable: true,
      sortOrder: 'asc',
      showColumns: true,
      showRefresh: true,
      columns: [{
          field: 'id',
          title: 'ID',
          sortable: true,
          align: 'center',
        },
        {
          field: 'name',
          title: 'Name',
          sortable: true,
        },
        {
          field: 'category_name',
          title: 'Category',
          sortable: true,
        },
        {
          field: 'price',
          title: 'Price',
          sortable: true,
          align: 'right',
          formatter: function(value, row, index) {
            return 'Rp ' + number_format(value);
          },
        },
        {
          field: 'action',
          title: 'Action',
          align: 'center',
          formatter: function(value, row, index) {
            return '<button class="btn btn-sm btn-primary" onclick="viewProduct(' + row.id + ')">View</button>';
          },
        },
      ],
    });

    $('#search').keyup(function() {
      $table.bootstrapTable('refresh');
    });

    $('#category').change(function() {
      $table.bootstrapTable('refresh');
    });
  });

  function number_format(number) {
    return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, '.');
  }

  function viewProduct(id) {
    $.ajax({
      url: '<?php echo base_url('products/get_product_by_id/') ?>' + id,
      method: 'GET',
      dataType: 'json',
      success: function(response) {
        $('#modal-product .modal-title').html(response.name);
        $('#modal-product .modal-body').html(
          '<p><strong>Category:</strong> ' + response.category_name + '</p>' +
          '<p><strong>Price:</strong> Rp ' + number_format(response.price) + '</p>' +
          '<p><strong>Description:</strong></p>' +
          '<p>' + response.description + '</p>'
        );
        $('#modal-product').modal('show');
      },
      error: function() {
        alert('Error: Could not retrieve product details.');
      }
    });
  }
</script>

<div class="row mb-3">
  <div class="col-md-6">
    <form>
      <div class="input-group">
        <input type="text" class="form-control" id="search" placeholder="Search...">
        <div class="input-group-append">
          <button type="button" class="btn btn-outline-secondary" onclick="$('#search').val('');">Clear</button>
        </div>
      </div>
    </form>
  </div>
  <div class="col-md-6">
    <select class="form-control" id="category">
      <option value="">All Categories</option>
      <?php foreach ($categories as $category) { ?>
        <option value="<?php echo $category['id'] ?>"><?php echo $category['name'] ?></option>
      <?php } ?>
    </select>
  </div>
</div>

<table id="table">



<div class="container mt-5">
    <div class="row">
        <div class="col-md-4">
            <h4>Categories</h4>
            <ul class="list-group">
                <?php foreach ($categories as $category): ?>
                    <li class="list-group-item">
                        <a href="<?= base_url('products?category_id=' . $category['id']) ?>"><?= $category['name'] ?></a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <div class="col-md-8">
            <h4>Products</h4>
            <table id="table"
                   data-toggle="table"
                   data-url="<?= base_url('products/get_data') ?>"
                   data-query-params="queryParams"
                   data-pagination="true"
                   data-side-pagination="server"
                   data-page-size="10"
                   data-page-list="[10, 25, 50, 100]"
                   data-search="true"
                   data-search-on-enter-key="true"
                   data-detail-view="true"
                   data-detail-formatter="detailFormatter"
                   data-detail-view-icon="false"
                   data-detail-view-align="right"
                   >
                <thead>
                <tr>
                    <th data-field="name" data-sortable="true">Name</th>
                    <th data-field="category_name" data-sortable="true">Category</th>
                    <th data-field="price" data-sortable="true">Price</th>
                </tr>
                </thead>
            </table>
        </div>
    </div>
</div>

<script>
    function queryParams(params) {
        params.search = $('#search').val();
        params.category_id = $('#category_id').val();
        return params;
    }

    function detailFormatter(index, row) {
        return `
            <div class="row">
                <div class="col-md-4">Description:</div>
                <div class="col-md-8">${row.description}</div>
            </div>
        `;
    }

    $(document).ready(function () {
        $('#search').on('keyup', function () {
            $('#table').bootstrapTable('refresh');
        });
        $('#category_id').on('change', function () {
            $('#table').bootstrapTable('refresh');
        });
    });
</script>
