<?php
defined('BASEPATH') or exit('No direct script access allowed');

Class Authcontroller extends MY_Controller
{
    function __construct()
	{
       parent::__construct();
       $this->load->library('form_validation');
       $this->load->library('authorization');
		$this->load->model('authmodel');
		//$data['DataView'] = $this->home_model->DataView();
    }
    
    public function index()
	{
		
		//$this->load->model('authmodel');

		$auth = new Authorization($this->load->model('authmodel'));
		$UserName = trim($this->input->post('username'));
		$UserPwd  = trim($this->input->post('pass'));
        $userdata = $this->authmodel->getValidUserData($UserName, $UserPwd);
        // print_r($userdata);
        // die();
        if (!empty($userdata))
		{
			$token = $auth->getJWTToken($UserName);
			$this->authmodel->saveToken($userdata['id'],$token);
			$this->authmodel->UpdateLoginFlag($UserName);
			$userdata['token'] = $token;
			$userdata_fix = $this->authmodel->getData($userdata['id']);
			if(!empty($userdata_fix)){
			$this->session->set_userdata($userdata_fix);
				// $this->session->set_userdata(array('id' => 0, 'username' => $userdata[0]['username'])); 
				// $this->session->set_userdata(array('logged_in' => true,
				//   'id' => $userdata['id'],
				//    'username' => $userdata['username'],
				//    'token' => $userdata['token']
				// ));
				// $this->load->view('admin/waiting');
				redirect('admin');
			}
        }
        else
		{
			//controller
            redirect('admin');
        }
	}

	public function set_pairing_flag(){
		$ip = trim($this->input->post('ip'));
		$token = trim($this->input->post('token'));
		$action = trim($this->input->post('action'));
		$auth = new Authorization($this->load->model('authmodel'));
		$check = $auth->checkJWTToken($token);
		if(!empty($check)){
			$change_flag = $this->authmodel->change_flag_pairing($ip,$action);
			$resp = [
				'message' => "Success",
				'status'  => true,
			];

			echo json_encode($resp);
			return;
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
	}

	public function set_wrong_flag_zero(){
		$ip = trim($this->input->post('ip'));
		$token = trim($this->input->post('token'));
		$action = trim($this->input->post('action'));
		$auth = new Authorization($this->load->model('authmodel'));
		$check = $auth->checkJWTToken($token);
		if(!empty($check)){
			$change_flag = $this->authmodel->change_flag_wrong_face($ip,$action);
			$resp = [
				'message' => "Success",
				'status'  => true,
			];

			echo json_encode($resp);
			return;
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
	}

	public function get_status_id_second(){
		$id = trim($this->input->post('id'));
		$token = trim($this->input->post('token'));
		$auth = new Authorization($this->load->model('authmodel'));
		$check = $auth->checkJWTToken($token);
		if(!empty($check)){
			$check = $this->authmodel->checkStatusIDSecond($id,$token);
			if (!empty($check)){
				$resp = [
					'message' => $check,
					'status'  => true,
				];
	
				echo json_encode($resp);
				return;
			}
			else {
				$cek_flag = $this->authmodel->getData($id);
				if ($cek_flag['is_wrong_face'] == 0){
					$resp = [
						'message' => "ID Belum melakukan Verifikasi Wajah",
						'code' => 'timeout',
						'status'  => false,
					];
		
					echo json_encode($resp);
					return;
				}
				else {
					$resp = [
						'message' => "ID Belum melakukan Verifikasi Wajah",
						'code' => 'wrong',
						'status'  => false,
					];
		
					echo json_encode($resp);
					return;
				}
				
			}
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
	}

	public function get_status_id(){
		$id = trim($this->input->post('id'));
		$token = trim($this->input->post('token'));
		$auth = new Authorization($this->load->model('authmodel'));
		$check = $auth->checkJWTToken($token);
		if(!empty($check)){
			$check = $this->authmodel->checkStatusID($id,$token);
			if (!empty($check)){
				$resp = [
					'message' => $check,
					'status'  => true,
				];
	
				echo json_encode($resp);
				return;
			}
			else {
				$cek_flag = $this->authmodel->getData($id);
				if ($cek_flag['is_wrong_face'] == 0){
					$resp = [
						'message' => "ID Belum melakukan Verifikasi Wajah",
						'code' => 'timeout',
						'status'  => false,
					];
		
					echo json_encode($resp);
					return;
				}
				else {
					$resp = [
						'message' => "ID Belum melakukan Verifikasi Wajah",
						'code' => 'wrong',
						'status'  => false,
					];
		
					echo json_encode($resp);
					return;
				}
				
			}
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
	}

	public function get_status_device(){
		$ip = trim($this->input->post('ip'));
		// if ($ip == "192.168.1.101"){
		// 	$resp = [
		// 		'message' => "Data ",
		// 		'data' => $ip,
		// 		'status'  => true
		// 	];

		// 	echo json_encode($resp);
		// 	return;
		// }
		// else {
		// 	$resp = [
		// 		'message' => "Data Berhasil Diambil",
		// 		'data' => $ip,
		// 		'status'  => false
		// 	];

		// 	echo json_encode($resp);
		// 	return;
		// }
		$resp = [
			'message' => "Data Masuk",
			'data' => $ip,
			'status'  => true
		];

		echo json_encode($resp);
		return;
	}

	public function getIdByUsername($username){
		// $username = trim($this->input->post('username'));
		$auth = new Authorization($this->load->model('authmodel'));
		$check = $auth->checkJWTToken($this->getBearerToken());
		if(!empty($check)){
			$data_id = $this->authmodel->getIdPolos($username);
			if (!empty($data_id)){
				$resp = [
					'message' => "Data Berhasil Diambil",
					'data' => $data_id,
					'status'  => true
				];
	
				echo json_encode($resp);
				return;
			}
			else {
				$resp = [
					'message' => "Error, Username salah",
					'status'  => false,
				];

				echo json_encode($resp);
				return;
			}
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'id_message' => "token_wrong",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
	}

	function getAuthorizationHeader(){
        $headers = null;
        if (isset($_SERVER['Authorization'])) {
            $headers = trim($_SERVER["Authorization"]);
        }
        else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
            $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
            // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
            //print_r($requestHeaders);
            if (isset($requestHeaders['Authorization'])) {
                $headers = trim($requestHeaders['Authorization']);
            }
        }
        return $headers;
    }

	function getBearerToken() {
		$headers = $this->getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
				return $matches[1];
			}
		}
		return null;
	}

	public function postDataClockIn(){
        header('Content-Type: application/json');
		$auth = new Authorization($this->load->model('authmodel'));
		// $check = $auth->checkJWTToken($this->getBearerToken());
		$check = "1";
		if(!empty($check)){
			$auth = new Authorization($this->load->model('authmodel'));
			$user_id = trim($this->input->post('user_id'));
			$ip_absensi = trim($this->input->post('ip_absensi'));
			$time_absensi = trim($this->input->post('time_absensi'));
			$cek_username = $this->authmodel->getDataId($user_id);
			if (!empty($cek_username)) {
				$this->authmodel->CreateDataLogin($cek_username['id'],$ip_absensi,$time_absensi);
				$check_login = $this->checkLoggedIn($username);
				if ($check_login){
					$resp = [
						'message' => "Data Terverifikasi",
						'status'  => true,
					];
		
					echo json_encode($resp);
					return;
				}
				else {
					$resp = [
						'message' => "Data tidak terverifikasi, antara data login dan data alat tidak sesuai",
						'status'  => false,
					];
		
					echo json_encode($resp);
					return;
				}
			} 
			else {
				$resp = [
					'message' => "Username salah / tidak terdaftar",
					'status'  => false,
				];

				echo json_encode($resp);
				return;
			}
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
		
	}

	public function checkLoggedIn($username){
        header('Content-Type: application/json');
		// $username = trim($this->input->post('username'));
		$cek_username = $this->authmodel->getId($username);
		if (!empty($cek_username)) {
			$cek_login = $this->authmodel->checkLogin($cek_username['id'],$cek_username['last_login_ip']);
			if (!empty($cek_login)){
				$userdata = $this->authmodel->getData($cek_login['users_id']);
				if (!empty($userdata)){
					$this->authmodel->UpdateLoginFlagSuccess($username);
					$this->session->set_userdata($userdata);
					// $resp = [
					// 	'message' => "Akun telah di verifikasi dan bisa login",
					// 	'status'  => true,
					// ];
		
					// echo json_encode($resp);
					return true;
				}
				else {
					// $resp = [
					// 	'message' => "Data salah",
					// 	'status'  => false,
					// ];
		
					// echo json_encode($resp);
					return false;
				}
			}
			else {
				// $resp = [
				// 	'message' => "Akun Belum Melakukan verifikasi wajah",
				// 	'status'  => false,
				// ];
	
				// echo json_encode($resp);
				return false;
			}
		}
		else {
			// $resp = [
            //     'message' => "Username salah / tidak terdaftar",
            //     'status'  => false,
            // ];

            // echo json_encode($resp);
            return false;
		}
	}

	public function redirectNoAuthRead($UserID, $MenuID)
	{
		$this->load->model('authmodel');
        $isauthread = $this->authmodel->getAuthRead($UserID, $MenuID);
		
        if (!$isauthread){
         	redirect('admin_login/redirectNoAuthUser');
        }
    }
	


	public function login_application(){
		$username = trim($this->input->post('username'));
		$password = trim($this->input->post('password'));
		$ip_terminal = trim($this->input->post('ip_terminal'));
		$auth = new Authorization($this->load->model('authmodel'));

		$cek_login = $this->authmodel->getValidUserData($username, $password,true);
		if(!empty($cek_login)){
			$this->authmodel->UpdateLoginFlag($username,$ip_terminal);
			$token = $auth->getJWTToken($username);
			$resp = [
				'data' => array(
					'token' => $token
				),
                'message' => "Login Berhasil",
                'status'  => true,
            ];

            echo json_encode($resp);
            return;
		}
		else {
			$resp = [
                'message' => "Username atau Password salah",
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
		}
	}

	public function check_login($username){
		$token = $auth->getJWTToken($username);
		// if ()
	}
	public function ChangeLanguage()
	{
		//echo ($url=$this->uri->ruri_string());
		// $this->session->sess_destroy();
		
		$lang = $this->input->post('lang');
		$url  = $this->input->post('url');
		
		$data = array(
						array(
							'id'   => '0',
							'lang' => 'indonesia'
						),
						array(
							'id'   => '1',
							'lang' => 'english'
						)
					);
		
		$this->session->set_userdata($data[$lang]);
		
		//echo $this->session->userdata('lang');
		//echo $Flg;
		redirect($url);
		//return $site
    }

	public function clear_data_log(){
		$id = trim($this->input->post('id'));
		$token = trim($this->input->post('token'));
		$auth = new Authorization($this->load->model('authmodel'));
		$check = $auth->checkJWTToken($token);
		if(!empty($check)){
			$check = $this->authmodel->clear_log($id);
			$resp = [
				'message' => "Data Sudah Dihapus",
				'status'  => true,
			];

			echo json_encode($resp);
			return;
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
	}
}   
?>