<?php
defined('BASEPATH') or exit('No direct script access allowed');

Class Api extends MY_Controller
{
    function __construct()
	{
       parent::__construct();
       $this->load->library('form_validation');
       $this->load->library('authorization');
		$this->load->model('authmodel');
		//$data['DataView'] = $this->home_model->DataView();
    }

	public function get_id($username){
		// $username = trim($this->input->post('username'));
		$auth = new Authorization($this->load->model('authmodel'));
		$check = $auth->checkJWTToken($this->getBearerToken());
		if(!empty($check)){
			$data_id = $this->authmodel->getIdPolos($username);
			if (!empty($data_id)){
				$resp = [
					'message' => "Data Berhasil Diambil",
					'data' => $data_id,
					'status'  => true
				];
	
				echo json_encode($resp);
				return;
			}
			else {
				$resp = [
					'message' => "Error, Username salah",
					'status'  => false,
				];

				echo json_encode($resp);
				return;
			}
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
	}

	function getAuthorizationHeader(){
        $headers = null;
        if (isset($_SERVER['Authorization'])) {
            $headers = trim($_SERVER["Authorization"]);
        }
        else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
            $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
            // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
            //print_r($requestHeaders);
            if (isset($requestHeaders['Authorization'])) {
                $headers = trim($requestHeaders['Authorization']);
            }
        }
        return $headers;
    }

	function getBearerToken() {
		$headers = $this->getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
				return $matches[1];
			}
		}
		return null;
	}

	public function post_data_absensi(){
        header('Content-Type: application/json');
		$auth = new Authorization($this->load->model('authmodel'));
		// $check = $auth->checkJWTToken($this->getBearerToken());
		$check = 1;
		if(!empty($check)){
			$auth = new Authorization($this->load->model('authmodel'));
			$user_id = trim($this->input->post('user_id'));
			$ip_absensi = trim($this->input->post('ip_absensi'));
			$time_absensi = trim($this->input->post('time_absensi'));
			$cek_username = $this->authmodel->getData($user_id);
			if (!empty($cek_username)) {
				$check_pairing =  $this->authmodel->check_pairing($cek_username['last_login_ip']);
				if (!empty($check_pairing)){
					$this->authmodel->CreateDataLogin($cek_username['id'],$ip_absensi,$time_absensi);
					$check_login = $this->checkLoggedIn($cek_username['username']);
					if ($check_login){
						$resp = [
							'message' => "Data Terverifikasi",
							'status'  => true,
						];
			
						echo json_encode($resp);
						return;
					}
					else {
						$resp = [
							'message' => "Data tidak terverifikasi, antara data login dan data alat tidak sesuai",
							'status'  => false,
						];
			
						echo json_encode($resp);
						return;
					}
				}
				else {
					$resp = [
						'message' => "Harap melakukan face recognizing pada saat diperintahkan pada website (Selama 30 Detik)",
						'data' => $cek_username,
						'status'  => false,
					];
		
					echo json_encode($resp);
					return;
				}
			} 
			else {
				$this->authmodel->change_flag_wrong_face($ip_absensi,1,1);
				$resp = [
					'message' => "User Id salah / tidak terdaftar",
					'status'  => false,
				];

				echo json_encode($resp);
				return;
			}
		}
		else {
			$resp = [
				'message' => "Access Denied (Token Wrong)",
				'status'  => false,
			];

			echo json_encode($resp);
			return;
		}
		
	}

	public function checkLoggedIn($username){
        header('Content-Type: application/json');
		$cek_username = $this->authmodel->getId($username);
		if (!empty($cek_username)) {
			$cek_login = $this->authmodel->checkLogin($cek_username['id'],$cek_username['last_login_ip']);
			if (!empty($cek_login)){
				$userdata = $this->authmodel->getData($cek_login['users_id']);
				if (!empty($userdata)){
					$this->authmodel->UpdateLoginFlagSuccess($username);
					$this->session->set_userdata($userdata);
					return true;
				}
				else {
					return false;
				}
			}
			else {
				return false;
			}
		}
		else {
            return false;
		}
	}


	public function login_application(){
		$username = trim($this->input->post('username'));
		$password = trim($this->input->post('password'));
		$ip_terminal = trim($this->input->post('ip_terminal'));
		$auth = new Authorization($this->load->model('authmodel'));

		$cek_login = $this->authmodel->getValidUserData($username, $password,true);
		if(!empty($cek_login)){
			$this->authmodel->UpdateLoginFlag($username,$ip_terminal);
			$token = $auth->getJWTToken($username);
			$resp = [
				'data' => array(
					'token' => $token
				),
                'message' => "Login Berhasil",
                'status'  => true,
            ];

            echo json_encode($resp);
            return;
		}
		else {
			$resp = [
                'message' => "Username atau Password salah",
                'status'  => false,
            ];

            echo json_encode($resp);
            return;
		}
	}
}   
?>
